<?php
defined('_JEXEC') or die ('Restricted Access');
jimport('joomla.application.component.controller');

class TeleskillController extends JController {
	function __construct($default=array()) {
		parent::__construct($default);
		$this->registerTask('add','edit');
		$this->registerTask('apply','save');
		$this->registerTask('unpublish','publish');	
	}

	function edit() {
		global $option;
		$row=&JTable::getInstance('teleskill','Table');
		$cid=JRequest::getVar('cid',array(0),'','array');
		$id=$cid[0];
		$row->load($id);
	
	
		$lists=array();
		$lists['wizard']=JHTML::_('select.booleanlist','wizard','class="inputbox"',$row->wizard);
		$lists['published']=JHTML::_('select.booleanlist','published','class="inputbox"',$row->published);
	
		HTML_teleskill::editTeleskill($row,$lists,$option);
	}
	
	function save() {
		global $option;
		$row=&JTable::getInstance('teleskill','Table');
		
		 if ($_POST['check']=='post') {
		 		$jAp=& JFactory::getApplication();
		 		 $jAp->enqueueMessage(JText::_('ERRORE CAMPI'),'error');
				return false;
		 }
		
		
		if (!$row->bind(JRequest::get('post'))) {
			echo $row->getError();
			exit();
		}
	
		$row->descrizione=JRequest::getVar('descrizione','','post','string',JREQUEST_ALLOWRAW);
		
		$ts=new Teleskill_API();
		if (!$ts->_client_code) {
			$link="index.php?option=".$option;	
			$this->setRedirect($link,JText::_('MANCA CODICE CLIENTE'),"error");	
		} else {
		
		if ($row->id) {
			//modifica stanza
			$res=$ts->editRoom($row->roomid,$row->nome);
		} else {
			//creazione stanza
			$res=$ts->createRoom($row->nome);	
		}
		
		if ($res['errorcode']) {
			echo $res['errormessage'];
			exit();
		}
		
		if (!$row->id) 
			$row->roomid=$res['roomid'];
		
		if (!$row->store()) {
			echo $row->getError();
			exit();
		}
		
		switch($this->_task) {
			case 'apply':
				$msg=JText::_('MODIFICHE SALVATE');
				$link="index.php?option=".$option."&task=edit&cid[]=".$row->id;
				break;
			
			case 'save':
			default:
				$msg=JText::_('STANZA SALVATA');
				$link="index.php?option=".$option;	
				break;			
		}	
	
		$this->setRedirect($link,$msg);	
		}
	}
	
	function showTeleskill() {
		global $option;
		$db=&JFactory::getDBO();
		$query="SELECT * FROM #__teleskill";
		$db->setQuery($query);
		$rows=$db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return false;
		}
	
			HTML_teleskill::showTeleskill($option,$rows);			
	}
	
	function remove() {
		global $option;
		$ts=new Teleskill_API();
		if (!$ts->_client_code) {
			$link="index.php?option=".$option;	
			$this->setRedirect($link,JText::_('MANCA CODICE CLIENTE'),"error");	
		} else {
		
		$cid=JRequest::getVar('cid',array(),'','array');
		$db=JFactory::getDBO();
		if (count($cid)) {
			$cids=implode(',',$cid);
			$query="DELETE FROM #__teleskill WHERE id IN ($cids)";
			$db->setQuery($query);
			if (!$db->query()) {
				echo $db->getErrorMsg();
				exit();
			}	
		}
		
		
		for ($i=0;$i<count($cid);$i++) {
			$query="SELECT roomid FROM #__teleskill WHERE id='".$cid[$i]."'";
			$db->setQuery($query);
			$row=$db->loadObject();
			$ts->removeRoom($row->roomid);
		}
		
		$this->setRedirect("index.php?option=".$option);
		}
			
	}


	function publish() {
		global $option;
		$cid=JRequest::getVar('cid',array(),'','array');
		if ($this->_task=='publish') {
			$publish=1;
		} else {
			$publish=0;
		}

		$db=JFactory::getDBO();
		if (count($cid)) {
			$cids=implode(',',$cid);
			$query="UPDATE #__teleskill SET published='$publish' WHERE id IN ($cids)";
			$db->setQuery($query);
			if (!$db->query()) {
				echo $db->getErrorMsg();
				exit();
			}	
		}
		$this->setRedirect("index.php?option=".$option);
	}
}
?>