<?php

$ts_dom=array();
$ts_cdata="";

function ts_loadXML($xml) {
	global $dom,$ts_cdata;
	
	$parser=xml_parser_create();
	xml_set_element_handler($parser,"ts_startElement","ts_endElement"); 
	xml_set_character_data_handler($parser, "ts_characterData"); 
 	if (!xml_parse($parser, $xml)) {
		 die(sprintf("XML error:%s at line %d",xml_error_string(xml_get_error_code($parser)),
xml_get_current_line_number($parser))); 
	};
}

function ts_startElement($parser_instance, $element_name, $attrs) { 
	global $ts_dom,$ts_cdata;
	$element_name=strtolower($element_name);
	$ts_dom[$element_name]="";
	$ts_cdata="";
};

function ts_characterData($parser_instance, $xml_data) { 
 	global $ts_dom,$ts_cdata;
	$ts_cdata.=$xml_data; 
 } 
  

function ts_endElement($parser_instance, $element_name) { 
	global $ts_dom,$ts_cdata;
	$element_name=strtolower($element_name);
	$ts_dom[$element_name]=$ts_cdata;
	$ts_cdata="";
}


class Teleskill_API {
	var $_serverAPI=null;
	var $_client_code=null;
	var $_logo=null;
	var $_skin=null;
	
	function __construct() {
		$params = &JComponentHelper::getParams( 'com_teleskill' );
		$this->_client_code=trim($params->get('client_code', ''));	
		
		$this->_serverAPI=trim($params->get('server_api', 'http://asp.teleskill.it/tvclive/server-1-1.asp'));	
		$this->_logo=trim($params->get('url_logo', ''));	
		$this->_skin=trim($params->get('url_css', ''));
		
	}
	
	function _sendRequest($xml_request) {		
		$xml_answer = false;
		$tmp_url = parse_url($this->_serverAPI);
		$post_data = urlencode('message').'='.urlencode($xml_request);
		$post_request = "POST $this->_serverAPI HTTP/1.0\r\n"
			."Host: ".$tmp_url['host']."\r\n"
			."User-Agent: PHP Script\r\n"
			."Content-type: application/x-www-form-urlencoded\r\n"
			."Content-length: ".strlen($post_data)."\r\n"
			."Connection: close\r\n\r\n"
			.$post_data."\r\n\r\n";
			
		
		$socket = fsockopen($tmp_url['host'], 80);

		if(!$socket) return false;
		socket_set_timeout($socket, 15);
		fputs($socket, $post_request);

		$head = fgets($socket);
		if(substr_count($head, "200 OK") > 0) {

			$hedaer_row = 0;
			while(!(fgets($socket) == "\r\n") && $hedaer_row < 100) { ++$hedaer_row; }
			if($hedaer_row == 100) return false;
		} else return false;
		while(!feof($socket)) {

			$xml_answer .= fgets($socket, 4096);
		}
		fclose($socket);

		return $xml_answer;
	}


	function createRoom($title,$descr = false,$logo = false, $skin=false) {
		global $ts_dom;
		
		$logo=$this->_logo;
		$skin=$this->_skin;
		
		$request = ''
		.'<?xml version="1.0" encoding="utf-8"?'.'>
		<ews type="1" lang="IT">
			<clientcode>'.$this->_client_code.'</clientcode>
			<title>'.$title.'</title>';
		
		if($descr != false) $request .= '	<descr>'.$descr.'</descr>';
		if($logo != false) 	$request .= '	<logo absolute="1">'.$logo .'</logo>';
		if($skin != false) 	$request .= '	<skin absolute="1">'.$skin .'</skin>';
		$request .= '</ews>';

		$xml_answer = trim($this->_sendRequest($request));

		if($xml_answer === false) return array('errorcode' => -1, 'errormessage' => '', 'roomid' => '');
		
		ts_loadXML( trim($xml_answer) );
		
		$e_code 	= $ts_dom['errorcode'];
		$e_msg 		= $ts_dom['errormessage'];
		$roomid 	= $ts_dom['roomid'];
		
		return array(	'errorcode' => $e_code,
						'errormessage' => $e_msg,
						'roomid' => $roomid );
	}
	
	function editRoom($roomid,$title,$descr = false,$logo = false, $skin=false) {
		global $ts_dom;
		
		$logo=$this->_logo;
		$skin=$this->_skin;
		
		$request = ''
		.'<?xml version="1.0" encoding="utf-8"?'.'>
		<ews type="1" lang="IT">
			<clientcode>'.$this->_client_code.'</clientcode>
			<roomid>'.$roomid.'</roomid>
			<title>'.$title.'</title>';
		
		if($descr != false) $request .= '	<descr>'.$descr.'</descr>';
		if($logo != false) 	$request .= '	<logo absolute="1">'.$logo .'</logo>';
		if($skin != false) 	$request .= '	<skin absolute="1">'.$skin .'</skin>';
		$request .= '</ews>';

		$xml_answer = trim($this->_sendRequest($request));

		if($xml_answer === false) return array('errorcode' => -1, 'errormessage' => '');
		
		ts_loadXML(trim($xml_answer));
		
		$e_code 	= $ts_dom['errorcode'];
		$e_msg 		= $ts_dom['errormessage'];
		
		return array(	'errorcode' => $e_code,
						'errormessage' => $e_msg );
	}
	
	function removeRoom($roomid) {
		global $ts_dom;
		
		$request = ''
		.'<?xml version="1.0" encoding="utf-8"?'.'>
		<ews type="2" lang="IT">
			<clientcode>'.$this->_client_code.'</clientcode>
			<roomid>'.$roomid.'</roomid>';		
		$request .= '</ews>';

		$xml_answer = trim($this->_sendRequest($request));

		if($xml_answer === false) return array('errorcode' => -1, 'errormessage' => '');
		
		ts_loadXML(trim($xml_answer));
		
		$e_code 	= $ts_dom['errorcode'];
		$e_msg 		= $ts_dom['errormessage'];
		
		return array(	'errorcode' => $e_code,
						'errormessage' => $e_msg);
	}
	
	
	function loginIntoRoom($roomid, $role, $userid, $username, $wizard, $email = false) {
		global $ts_dom;
		
		$lg = &JFactory::getLanguage();
		$language = $lg->get('name');
		
		$lang="IT";
		if ($language=="English (United Kingdom)") $lang="EN";
		
		$request = ''
		.'<?xml version="1.0" encoding="utf-8"?'.'>
		<ews type="3" lang="'.$lang.'">
			<clientcode>'.$this->_client_code.'</clientcode>
			<roomid>'.$roomid.'</roomid>
			<lmsuserid>'.$userid.'</lmsuserid>
			<role>'.$role.'</role>
			<wizard>'.$wizard.'</wizard>
			<name>'.$username.'</name>';
		if($email != false) $request .= ' <email>'.$email.'</email >';
		$request .= '</ews>';

		$xml_answer = trim($this->_sendRequest($request));

		if($xml_answer === false) return array('errorcode' => -1, 'errormessage' => '', 'url' => '');

		ts_loadXML(trim($xml_answer));
		
		$e_code 	= $ts_dom['errorcode'];
		$e_msg 		= $ts_dom['errormessage'];
		$url 		= $ts_dom['url'];


		return array('errorcode' => $e_code, 'errormessage' => $e_msg, 'url' => $url);
	}

		
}

?>