<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die;
jimport('joomla.application.component.controllerform');

/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */
class TliveControllerSavereports extends JControllerForm {


  	/**
	 * Method to save reports
	 *
	 * @param   void	
	 * @return boolean
	 *
	 * @since   1.6
	 */
	function save() {
	
	    $app = JFactory::getApplication();
	    $id = JRequest::getVar('id',0,'post','int');
	    $roomid = JRequest::getVar('roomid',0,'post','int');
        
        $model = $this->getModel();
		
		$curlResponse = TliveHelper::getRoomLogs($roomid);	
		
		if (!empty($curlResponse) && isset($curlResponse->errorcode) ) {
			
			$blnSuccess = $model->saveLogs($curlResponse);
			
		} else {			
			
			$app->redirect('index.php?option=com_tlive&view=roomsessions&id='.$id,JText::_('COM_TLIVE_MESSAGE_ERROR_NOTRESPONSE'),'warning');
			return false;
			
		}
		
		
		
		if ($blnSuccess) {
			
			$app->redirect('index.php?option=com_tlive&view=roomsessions&id='.$id,JText::_('COM_TLIVE_ROOMSESSIONS_STATS_SUCCESS','message') );
			
		} else {
			
			$app->redirect('index.php?option=com_tlive&view=roomsessions&id='.$id,JText::_('COM_TLIVE_ROOMSESSIONS_STATS_FAILED','warning'));
			
		}			
	
		return true;	

	}
	
	
	
}
