<?php

/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die;
jimport('joomla.application.component.modeladmin');


/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */
class TliveModelClass extends JModelAdmin {


     /**
	 * Method to get the row form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	  public function getForm($data = array(), $loadData = true) {

		$params = JComponentHelper::getParams('com_tlive');


		switch((int)$params->get('disable_date')) {

			case 0:
			$source = 'class';
			break;
			/* if room scheduling is disabled load this form*/
			case 1:
			$source = 'class_nodate';
			break;

		}

	    // Get the form.

	    $form = $this->loadForm('com_tlive.class_nodate', $source, array('control' => 'jform', 'load_data' => $loadData));


		return $form;

	  }

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.6
	 */
	  protected function loadFormData() {
	    // Check the session for previously entered form data.
	    $data = JFactory::getApplication()->getUserState('com_tlive.edit.class.data', array());


	    if(empty($data)){

	      $data = $this->getItem();

	    }

	    return $data;

	  }

	 /**
	 * Method to get a table object, load it if necessary.
	 *
	 * @param   string  $type    The table name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JTable  A JTable object
	 *
	 * @since   1.6
	*/
	  public function getTable($name = 'Classes', $prefix = 'TliveTable', $options = array()) {

	  	return parent::getTable($name, $prefix, $options);

	  }


  /**
	 * Method to save room data.
	 *
	 * @param   object  $data    Data for the form
	 * @return  boolean
	 *
	 * @since   1.6
	*/
	  public function saveClass($data) {

	    //teacher role
		$role=2;
		$teacher_id = $data['select_teacher'];
		$blnConfmanemail = $data['emailconfman'];
		$blnUsersemail = $data['emailusers'];


		//boolean var to track if save operation is successfull
		$blnConfirm = false;
		//Error message string
		$strErrorMsg = "";
		$db =& JFactory::getDBO();

		$app = Jfactory::getApplication();
		//Last room id inserted
		$lastClassId=0;


		//if is a new room
		if (empty($data['id'])) {
			$blnAddNew = true;
		}
	    //if editing a room
		else {
			$blnAddNew = false;
		}

		/* If no conference manager is selected, raise warning */
	    if( $teacher_id == 0) {

	    	$app->setUserState( 'com_tlive.edit.class.data', $data );
	    	$this->setError(JText::_('COM_TLIVE_MESSAGE_ENROL_NOTEACHER_ERROR'));
	    	return false;

	    }



		if ($blnAddNew) {

			// Room creation
			$type=1;
			// Send request to TVCL server
			$curlResponse = TliveHelper::createRoom($data);

			// Check if XML response is not null
			if (!empty($curlResponse) && isset($curlResponse->errorcode) ) {

				//if room creation is successfull, insert room record in db
				if ((int)$curlResponse->errorcode == 0) {

					$query = "INSERT INTO #__tlive_classes (id,title,timestarted,timecompleted,logo,banner,roomid,users,auto_enrol,emailconfman,emailusers) VALUES ('$data[id]','$data[title]',
					'$data[timestarted]','$data[timecompleted]','$data[logo]','$data[banner]','$curlResponse->roomid','$data[users]','$data[auto_enrol]','$data[emailconfman]', '$data[emailusers]')";
					$db->setQuery($query);
					$db->query();

					//get record id inserted
					$lastClassId = $db->insertid();

					$blnConfirm=true;

				} else {
					$app->setUserState( 'com_tlive.edit.class.data', $data );
					$strErrorMsg  = (string)$curlResponse->errormessage;
					$this->setError($strErrorMsg);
				}

			} else {
				$app->setUserState( 'com_tlive.edit.class.data', $data );
				$strErrorMsg  = JText::_('COM_TLIVE_MESSAGE_ERROR_NOTRESPONSE');
				$this->setError($strErrorMsg);
			}

		//otherwise edit room
		} else {

			//edit room mode
			$type=6;
			//load room id
			$lastClassId = $data['id'];

			//load room record
			$query="SELECT * FROM #__tlive_classes WHERE id='$lastClassId'";
			$db->setQuery($query);
			$result = $db->loadObject();
			$roomid = $result->roomid;
			$timestarted = $result->timestarted;


			//Send request to TVCL server
			$curlResponse = TliveHelper::editRoom($data,$roomid);

			if (!empty($curlResponse) && isset($curlResponse->errorcode) ) {

				//if room edit is successfull, update room record in db
				if ((int)$curlResponse->errorcode == 0) {

					$query = "UPDATE #__tlive_classes SET title='$data[title]',timestarted='$data[timestarted]',timecompleted='$data[timecompleted]',logo='$data[logo]',banner='$data[banner]',users='$data[users]',auto_enrol='$data[auto_enrol]', emailconfman='$data[emailconfman]', emailusers='$data[emailusers]'  WHERE id='$data[id]'";
					$db->setQuery($query);
					$db->query();

					$blnConfirm=true;

				} else {
					$app->setUserState( 'com_tlive.edit.class.data', $data );
					$strErrorMsg  = (string)$curlResponse->errormessage;
					$this->setError($strErrorMsg);
				}

			} else {
				$app->setUserState( 'com_tlive.edit.class.data', $data );
				$strErrorMsg  = JText::_('COM_TLIVE_MESSAGE_ERROR_NOTRESPONSE');
				$this->setError($strErrorMsg);
			}
		}

		/* if operation is successful */
		if($blnConfirm) {

			/* retrieve old conference manager */
			$query="SELECT * FROM #__tlive_enrolments WHERE classroom_id='$lastClassId' AND role=2";
			$db->setQuery($query);
			$lastconfmanager = $db->loadObject();


			//clear old conference manager and update with the new
			$query="DELETE FROM #__tlive_enrolments WHERE classroom_id='$lastClassId' AND role=2";
			$db->setQuery($query);
			$db->query();

			if ($teacher_id != 0) {

				//echo $lastconfmanager->user_id.'<br>';
				//echo $teacher_id;
				//die;

		        $query="INSERT INTO #__tlive_enrolments (classroom_id,user_id,role) VALUES ('$lastClassId','$teacher_id','$role')";
				$db->setQuery($query);
				$db->query();

				/* check if conference manager is changed then send an email that notices old conference manager */
				if((int)$lastconfmanager->user_id != $teacher_id && $blnConfmanemail) {

					/* Not send this email when room is new because $lastconfmanager->user_id =0 */
					if(!$blnAddNew) {

						$lastconfmanager = JFactory::getUser($lastconfmanager->user_id);
						$recipient = $lastconfmanager->email;
						$subject = JText::sprintf('COM_TLIVE_ENROL_USERS_MAILSUBJECT',$data['title']);
						$body = JText::sprintf('COM_TLIVE_ENROL_CONFMANAGER_REMOVED_BODY',$data['title']);
						TliveHelper::sendEmail($recipient,$subject,$body);
					}

					/* send email to new conference manager */
					$confmanager = JFactory::getUser($teacher_id);
					$recipient = $confmanager->email;
					$subject = JText::sprintf('COM_TLIVE_ENROL_USERS_MAILSUBJECT',$data['title']);
					$url = JRoute::_(JURI::base().'/index.php?option=com_tlive&view=class&id='.$lastClassId,false);
					$url = str_replace('/administrator/', '', $url);
					
					//load config params
					$params =& JComponentHelper::getParams('com_tlive');
										
					if (!$params->get('disable_date')) {
					
						$body = JText::sprintf('COM_TLIVE_ENROL_CONFMANAGER_BODY',$data['title'],JHtml::_('date', $data['timestarted'], JText::_('DATE_FORMAT_LC2')),$url,$url);
					
					} else {
						
						$body = JText::sprintf('COM_TLIVE_ENROL_CONFMANAGER_BODY_NODATE',$data['title'],$url,$url);
					}
					
					
					TliveHelper::sendEmail($recipient,$subject,$body);


				}





			}

			/* if editing room */
			if(!$blnAddNew) {


				/* check if date event is changed, then send emails to users */
				if($data['timestarted'] != $timestarted && $blnUsersemail) {

					$query="SELECT u.id,u.email FROM #__tlive_enrolments AS e
						INNER JOIN #__users AS u ON e.user_id=u.id
						WHERE e.classroom_id='$lastClassId'";

					$db->setQuery($query);

					if ($users = $db->loadObjectList()) {

						$recipient = array();

						foreach($users as $user) {

							$recipient[] = $user->email;

						}

						$subject = JText::sprintf('COM_TLIVE_ENROL_USERS_MAILSUBJECT',$data['title']);
						$body = JText::sprintf('COM_TLIVE_ROOM_MAILDATACHANGED',$data['title'],JHtml::_('date', $data['timestarted'], JText::_('DATE_FORMAT_LC2')) );

						/* if there is at least one recipient, send email */
						if(!empty($recipient)) {

							TliveHelper::sendEmail($recipient,$subject,$body);

						}

					}


				}


			}
	   }

	   return $blnConfirm;

	 }


	/**
	 * Method to delete rooms records
	 *
	 * @param   object  $data    Data for the form
	 * @return  boolean
	 *
	 * @since   1.6
	*/
	 public function delete($cids){


	    //delete room mode
		$type = 2;

		//load rooms table
		$row =&  JTable::getInstance('classes','TliveTable');
		$db =& JFactory::getDBO();

		$blnConfirm=false;
		//count rooms deleted
		$itemsDeleted=0;

		foreach($cids as $cid){

			$query="SELECT roomid FROM #__tlive_classes WHERE id='$cid'";
			$db->setQuery($query);
			$result = $db->loadObject();
			$roomid = $result->roomid;

			//Send request to TVCL server
			$curlResponse = TliveHelper::deleteRoom($roomid);


			//if room edit is successfull, update db
			if ((int)$curlResponse->errorcode == 0 && isset($curlResponse->errorcode) ) {

				if ($row->delete( $cid )) {
				   //rimuovi ogni riferimento nella tabella dei partecipanti
				   $query="DELETE FROM #__tlive_enrolments WHERE classroom_id='$cid'";
				   $db->setQuery($query);

				   if(!$db->query()) {

			   	   		$this->setError(JText::_('COM_TLIVE_MESSAGE_ENROL_USERS_FAILED'));
				   		return false;

				   }

		        }

			} else {

				$this->setError(JText::_('COM_TLIVE_ERROR_SERVER_RESPONSE'));
				return false;

			}


		}


		return true;


	}





}
