<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.modellist');

/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */ 
class TliveModelEnroluser extends JModelList {
	
	/**
	 * Method to get the row form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */	
  public function getForm($data = array(), $loadData = true){
   //Load form object
    $form = $this->loadForm('com_tlive.enroluser', 'enroluser', array('control' => 'jform', 'load_data' => $loadData));
    return $form;
  }
 
 
 /**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.6
 */ 
  protected function loadFormData(){
    // Check the session for previously entered form data.
    $data = JFactory::getApplication()->getUserState('com_tlive.edit.enroluser.data', array());
    if(empty($data)){
      $data = $this->getItem();
    }
		
    return $data;
  }
  
 /**
	 * Method to get a table object, load it if necessary.
	 *
	 * @param   string  $type    The table name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JTable  A JTable object
	 *
	 * @since   1.6
	*/ 
  public function getTable($name = 'Enroluser', $prefix = 'TliveTable', $options = array()){
  	
    return parent::getTable($name, $prefix, $options);
  }
  
  /**
	 * Method to get items list
	 *	 
	 *
	 * @return  string  DB query string
	 *
	 * @since   1.6
	*/ 
  public function getListQuery() {
		
		$class_id = JRequest::getVar('id');
				
		$query = 'SELECT u.id,u.name,e.role FROM #__users AS u
				INNER JOIN #__tlive_enrolments AS e ON u.id=e.user_id
				WHERE e.classroom_id='.$class_id.' AND e.role=1
				UNION 
				SELECT u.id,u.name, 0 AS role FROM #__users AS u
				WHERE u.id NOT IN 
				(SELECT user_id FROM #__tlive_enrolments AS e
				WHERE classroom_id='.$class_id.' AND (e.role=1 OR e.role=2))
				ORDER BY name ASC';
				
				
		return $query;					
		
		
	}
  
  /**
	 * Method to enrol users to a specific room
	 *
	 * @param   array  $user_ids  List of selected users
	 * @param  int $classroom_id Room id
	 * @return  boolean
	 *
	 * @since   1.6
	*/
  public function save($user_ids,$classroom_id){	
				
		//User role
		$role = 1;
		$db = JFactory::getDbo();	
		/* load room record */
		$query="SELECT * FROM #__tlive_classes WHERE id='$classroom_id'";
		$db->setQuery($query);
		$room = $db->loadObject();	
		
		$blnUsersemail = $room->emailusers;
		
		/* load temporarily old user list */    		
		$query="SELECT * FROM #__tlive_enrolments WHERE classroom_id='$classroom_id' AND role=$role";
		$db->setQuery($query);
		$oldlist = $db->loadAssocList('user_id');		
		
		 //Clear all user previously enrolled and update with new		 
		 $query="DELETE FROM #__tlive_enrolments WHERE classroom_id='$classroom_id' AND role=$role";
		 $db->setQuery($query);
		 $db->execute();
		 
		 $recipient = array();
	
		foreach ($user_ids as $u) {
						
			
			$query = "INSERT INTO #__tlive_enrolments (classroom_id,user_id,role) VALUES ('$classroom_id','$u','$role')";
			$db->setQuery($query);
			
			if (!$db->execute() ) {
				
				return false;	
			}
			
			
			
			/* check if user is already enrolled,  otherwise send him and email */			
			if(!isset($oldlist[$u])) {
				
								
				$user = JFactory::getUser($u);
				$recipient[] = $user->email;
				
				
			}
		}
		
		/* build email message */
		if(!empty($recipient) && $blnUsersemail) {			
			
			
			$subject = JText::sprintf('COM_TLIVE_ENROL_USERS_MAILSUBJECT', $room->title);
			$url = JRoute::_(JURI::base().'/index.php?option=com_tlive&view=class&id='.$classroom_id,false);
			$url = str_replace('/administrator/', '', $url);
			
			//load config params
			$params =& JComponentHelper::getParams('com_tlive');										
			if (!$params->get('disable_date')) {
				
				$body = JText::sprintf('COM_TLIVE_ENROL_USER_BODY',$room->title,JHtml::_('date', $room->timestarted, JText::_('DATE_FORMAT_LC2')),$url,$url);
				
			} else {	
			
				$body = JText::sprintf('COM_TLIVE_ENROL_USER_BODY_NODATE',$room->title,$url,$url);
			}	
				
			TliveHelper::sendEmail($recipient,$subject,$body);
			
		}
		
		return true;
					
		  
		  
	}
	
	
}
