<?php

jimport('joomla.application.component.modelitem');

/**
 * Model for the Joomla Tlive component.
 *
 * @package		Joomla.Site
 * @subpackage	com_tlive
 */
class TliveModelEventsdata extends JModelItem {
	
	protected $item;
	
	
	public function getItem() {	
		
		$user = JFactory::getUser();
		$config = JFactory::getConfig();
		$timezone = $user->getParam('timezone', $config->getValue('config.offset'));
		
		
		$db = JFactory::getDbo();
		$db->setQuery('SELECT * FROM #__tlive_classes as cs');
		
		$res = $db->loadObjectList();
		$json = array();
		
		/* Load events already scheduled, not writable */
		
		$count=1;
		$update = JRequest::getVar('update',0,'get','integer');
		
		if (!empty($res)) {
		
		    foreach ($res as $r) {
		
		        if ($r->id!=$update) {
		        	
		        	/* print datetime according to user time zone (datetime is stored in db in UTC) */
		        	$start = JFactory::getDate($r->timestarted,'UTC');
		        	$start->setTimeZone(new DateTimeZone($timezone)); 
		        	
		        	$end = JFactory::getDate($r->timecompleted,'UTC');
		        	$end->setTimeZone(new DateTimeZone($timezone));   	
		
		            $json[] = array(
		            'id'=>$count,
		            'title'=> $r->title,
		            'start'=> $start->toISO8601(true),
		            'end'=> $end->toISO8601(true),
		            'users'=> (int)$r->users,
		            'readonly'=>'true'
		            );
		
		            $count++;
		        }
		
		    }
		}
		
		/* Load temporary event created at the end of list
		 * if already inserted, load its title from db, else print "New event"
		 */
		$db->setQuery('SELECT * FROM #__tlive_classes WHERE id='.$update); 
		$titleupdate = $db->loadObject();
		$title="";
		
		if (!empty($titleupdate->title)) {
		    $title = $titleupdate->title;
		} else {
		    $title= JText::_('Nuovo evento');
		}
		
		
		if (!empty($_GET)) {
		
		    $start = JRequest::getVar('s','','get','string');
		    $end = JRequest::getVar('e',0,'get','string');
		    $users = JRequest::getVar('u',0,'get','integer');    
		    
		
		    /* If user time zone is not equal to server local time set default time zone as user time zone */
		    /*$timezone = usertimezone();
		    if ($timezone!= get_string('serverlocaltime')) {
		        date_default_timezone_set($timezone);
		    }*/
		    
		    $timezone = $user->getParam('timezone',$config->getValue('config.offset'));    
		    
		    /* If user time zone is not equal to server local time set default time zone as user time zone */
		    /*if ($timezone!= $config->getValue('config.offset')) {
		    	
		        date_default_timezone_set($timezone);
		    }*/
		    
		    date_default_timezone_set($timezone);
		    $start =  strtotime($start);
		    $end =  strtotime($end);    
		   
		    
		    /* riscrive la data rispetto alla timezone dell'utente */
			$start = JFactory::getDate($start,$config->getValue('config.offset'));
			$start->setTimeZone(new DateTimeZone($timezone)); 
			
			$end = JFactory::getDate($end,$config->getValue('config.offset'));
			$end->setTimeZone(new DateTimeZone($timezone));     
		    
		    
		
		    $json[] = array(
		        'id'=>$count,
		        'title'=>$title,
		        'start'=>$start->toISO8601(true),
		        'end'=>$end->toISO8601(true),
		        'users'=>$users,
		        'readonly'=>'false'
		        );
		}	
		
		
		
		
		$this->item = $json;
		
		return $this->item;
	
		
		
		
		
		
		
	}
	
		
	
	
	
	
	
	
	
}