<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license	GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.view');


/**
 * View class for display calendar
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */
class TliveViewCalendar extends JView
{
  /**
   * Display the view
   *
   * @return	void
   */	
  public function display($tpl = null) 
  {
    
  	$document =& JFactory::getDocument();
    $document->addStyleSheet('components/com_tlive/assets/js/weekcalendar/reset.css');
    $document->addStyleSheet('components/com_tlive/assets/js/weekcalendar/blitzer/jquery-ui.css');
    $document->addStyleSheet('components/com_tlive/assets/js/weekcalendar/jquery.weekcalendar.css');
    $document->addStyleSheet('components/com_tlive/assets/js/weekcalendar/calendar.css');
    
    $document->addScript('components/com_tlive/assets/js/weekcalendar/jquery.min.js');
    $document->addScript('components/com_tlive/assets/js/weekcalendar/jquery.min.js');
    $document->addScript('components/com_tlive/assets/js/weekcalendar/jquery-ui.min.js');
    $document->addScript('components/com_tlive/assets/js/weekcalendar/jquery.weekcalendar.js');
    $document->addScript('components/com_tlive/assets/js/weekcalendar/calendar.js');
    
 	$lang =  JFactory::getLanguage()->getTag();    
    $document->addScript('components/com_tlive/assets/js/lang/'.$lang.'.js');
    
    // Set the toolbar
    $this->addToolBar();
 
    // Display the template
    parent::display($tpl);
  }
 
 /**
   * Add the page title and toolbar.
   *
   * @since	1.6
  */
  protected function addToolBar() 
  {
    JRequest::setVar('hidemainmenu', true);
    //$isNew = ($this->item->id == 0);
    /*JToolBarHelper::title($isNew ? JText::_('COM_TLIVE_MANAGER_CLASS_NEW') : JText::_('COM_TLIVE_MANAGER_CLASS_EDIT'),'class-toolbar');
    JToolBarHelper::save('class.save');
    JToolBarHelper::cancel('class.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');*/
  }
}
