<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license	GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.view');


/**
 * View class to edit a room
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */
class TliveViewClass extends JView
{
	
 /**
   * Display the view
   *
   * @return	void
   */
  public function display($tpl = null) 
  {
    // get the Data
    $form = $this->get('Form');
    $item = $this->get('Item');
    
    // Assign the Data
    $this->form = $form;
    $this->item = $item;
    
  	$document =& JFactory::getDocument();
    $document->addStyleSheet('components/com_tlive/assets/css/classes.css');
    $document->addStyleSheet('components/com_tlive/assets/js/jquery.multiselect.css');
    $document->addStyleSheet('components/com_tlive/assets/js/redmond/jquery-ui.css');
    $document->addStyleSheet('components/com_tlive/assets/js/redmond/jquery.multiselect.filter.css');
    $document->addScript('components/com_tlive/assets/js/jquery.js');
    $document->addScript('components/com_tlive/assets/js/jquery-ui.js');
    $document->addScript('components/com_tlive/assets/js/jquery.multiselect.js');
    $document->addScript('components/com_tlive/assets/js/jquery.multiselect.filter.js');
    // Set the toolbar
    $this->addToolBar();
 
    // Display the template
    parent::display($tpl);
  }
  
  
  /**
   * Add the page title and toolbar.
   *
   * @since	1.6
  */ 
  protected function addToolBar() 
  {
    JRequest::setVar('hidemainmenu', true);
    $isNew = ($this->item->id == 0);
    JToolBarHelper::title($isNew ? JText::_('COM_TLIVE_MANAGER_CLASS_NEW') : JText::_('COM_TLIVE_MANAGER_CLASS_EDIT'),'class-toolbar');
    JToolBarHelper::save('class.save');
    JToolBarHelper::cancel('class.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
  }
}
