<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */ 
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.view');

/**
 * View class to display room session
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */
class TliveViewRoomaccess extends JView {
	
	protected $items;
	protected $startdate;
	protected $enddate;
	
/**
   * Display the view
   *
   * @return	void
    */	
  public function display($tpl = null) {  
  	
  	$id = JRequest::getVar('id',0,'get','int');
  	$db = JFactory::getDbo();
  	$db->setQuery("SELECT * FROM #__tlive_rooms_sessions WHERE roomsessionid=$id");
  	$this->startdate = $db->loadObject()->startdate;  
    $this->enddate = $db->loadObject()->enddate; 
    
    $items = $this->get('Items');   
        
    $this->items = $items;
    
    $lang =  JFactory::getLanguage()->getTag();
    
    
  	$document =& JFactory::getDocument();
    $document->addStyleSheet('components/com_tlive/assets/css/classes.css');
    $document->addScript('components/com_tlive/assets/js/charts/jquery-1.9.1.min.js');
    $document->addScript('components/com_tlive/assets/js/charts/highstock.js');
    $document->addScript('components/com_tlive/assets/js/charts/users-access-chart.js');
    $document->addScript('components/com_tlive/assets/js/lang/'.$lang.'.js');
    // Set the toolbar
    $this->addToolBar();
 
    // Display the template
    parent::display($tpl);
    
    
  }
  
 /**
   * Add the page title and toolbar.
   *
   * @since	1.6
  */ 
  protected function addToolBar() {
  	
    JRequest::setVar('hidemainmenu', true);
    JToolBarHelper::title(JText::_('COM_TLIVE_MANAGER_TITLE_ROOM_ACCESS'),'statistics');
    JToolBarHelper::custom( 'roomaccess.saveexcel', 'excel', '', JText::_('COM_TLIVE_EXPORT_EXCEL'),false,false);
    JToolBarHelper::custom( 'roomaccess.savepdf', 'pdf', '', JText::_('COM_TLIVE_EXPORT_PDF'),false,false);
    JToolBarHelper::back();
  
  }
}
