<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */ 
 
// No direct access to this file
defined('_JEXEC') or die;
jimport('joomla.application.component.controllerform');

/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */
class TliveControllerClass extends JControllerForm {
    
    
    /**
	 * Method to save a record
	 *
	 * @param   void
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	function save($key=null, $urlVar=null) {
	
	 //*****Form validation *****
	    $app = JFactory::getApplication();
        $model = $this->getModel();
        $params = JComponentHelper::getParams('com_tlive');
		
		 //Load form data
		$data = JRequest::getVar('jform', null, 'post', 'array');
		$classroom_id =JRequest::getVar('id', 0, 'get', 'int'); 
	    // Validate the posted data.
        $form   = $model->getForm();
        
        
        if (!$form) {
	        JError::raiseError(500, $model->getError());
	        return false;
        }        
        
        $dataval   = $model->validate($form, $data);
        
 
        // Check for validation errors.
        if ($dataval === false) {
        	
	        // Get the validation messages.
	        $errors = $model->getErrors();
 
            // Push up to three validation messages out to the user.
            for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
            	
                if (JError::isError($errors[$i])) {
                	$app->enqueueMessage($errors[$i]->getMessage(), 'notice');
                	
                } else {
                	
                	$app->enqueueMessage($errors[$i], 'notice');
                }
            }
                     

	        // Redirect back to the edit screen.
	        $this->setRedirect(JRoute::_('index.php?option=com_tlive&view=class&layout=edit&id='.$data['id'], false));
	        return false;
        }          
              
	
		
		/* build unixtime timestamp (UTC), considering user timezone*/				
		$user = JFactory::getUser();
		$config = JFactory::getConfig();		
    	$timezone = $user->getParam('timezone', $config->get('offset')); 
    	
    	/* if room scheduling is enabled build time start and close, otherwise set start and close = 0 */
    	$timestarted = 0;
    	$timecompleted = 0;
    	
    	if((int)$params->get('disable_date') == 0) {
    	
	    	/* YYYY-MM-DD*/
	    	$match = array();
	    	preg_match("/^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})/",$data['timestarted'],$match);  	
	    		
	    			    	
	    	$day = JFactory::getDate($match[0],$timezone); 
	    	
	    	/* offset da sottrarre nel computo dei secondi (le ore selezionate sono quelle rispetto all'ora locale dell'utente */
	    	//$offset = $day->getOffsetFromGMT(); 
	    	
	    	    	
	    	/* riportiamo l'orario dell'utente in UTC */
	    	//$day->setTimeZone(new DateTimeZone('UTC'));   	
	    		 	
	    	
			/* convert in unix time, then sum hours and minutes */
	    	$day = $day->toUnix();     	     		
	    	
	    	$timestarted = $day + $data['start_hour']*3600 + $data['start_mins']*60;// - $offset;    	
	    	$timecompleted = $day + $data['close_hour']*3600 + $data['close_mins']*60;// - $offset;    	    	
			
			$timestarted = gmdate('Y-m-d H:i:s',$timestarted);		
			$timecompleted = gmdate('Y-m-d H:i:s',$timecompleted);	
		}
		
		
		$data['timestarted'] = $timestarted; 
		$data['timecompleted'] = $timecompleted; 	
		
		$helper = new TliveHelper();	
		
		/*if room scheduling is enabled, check event availability */
		if((int)$params->get('disable_date') == 0) {
		
			/* Check if the number of user is less than max user number, in according to selected time interval */
			if(!$helper->event_availability($data['timestarted'],$data['timecompleted'],$params->get('max_users'), $data['users'], $classroom_id)) {
				
				
				//JError::raiseWarning(500, $model->getError());
				//$this->setMessage($model->getError(),'error');
				$app->setUserState( 'com_tlive.edit.class.data', $data );
				$this->setMessage($helper->getError(),'error');
				$this->setRedirect('index.php?option=com_tlive&view=class&layout=edit&id='.(int) $classroom_id);
				return false;
				
			}	
		}
        
		$blnSuccess = $model->saveClass($data);
		
		//Print confirm or error message
		switch ($blnSuccess){
			case true: 
				$app->redirect('index.php?option=com_tlive&view=classes', $msg=JText::_('COM_TLIVE_MESSAGE_CLASS_SAVED'), 
				$msgType='message');
				break;
			case false: 
				$app->redirect('index.php?option=com_tlive&view=class&layout=edit&id='.$data['id'], $msg=$model->getError(), 
				$msgType='warning');				
				break;		
	    }
	    
	    return true;

	}
	
	/**
	 * Method to delete a record
	 *
	 * @param   void
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	 public function delete(){  		
  		
  	    //Load rooms ids to delete
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$model = $this->getModel();			
		
		// Remove the items.
		if (!$model->delete($cids)) {
			JError::raiseWarning(500, $model->getError());
		}
		else {
			$this->setMessage(JText::plural('COM_TLIVE_MESSAGE_CLASSES_DELETED', count($cids)));
		}
			
		//redirect to rooms view and print the rooms number removed
		$this->setRedirect('index.php?option=com_tlive&view=classes');	
		
		
	}
	
	
}
