<?php
/**
 * @author	Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
defined('_JEXEC') or die;

/**
 * Teleskill Live component helper.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */

class TliveHelper
{
	
	private $error;
	
	
	public function __construct() {
		
		$error = '';
	}
	
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  The name of the active view.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public static function addSubmenu($vName)
	{
		
	}
	
	/**
	 * Check event availability
	 *
	 * @param	string (datetime)$startdate Date and time when event begins
	 * @param   string (datetime)$enddate Date and time when event finishes
	 * @param   int $maxusers Number max of users allowed
	 * @param   int $users Number of users
	 * @param   int $classroom_id Roomid
	 * @return	boolean
	 * @since	1.6
	 */	
	public function event_availability($startdate,$enddate,$maxusers, $users, $classroom_id) {
		
		
	   		   		   
	    $db = JFactory::getDBO();	    
	        
	    /*$db->setQuery("SELECT timestarted,timecompleted FROM #__tlive_classes WHERE id=$classroom_id");   
	    
	    $class = $db->loadObject();	    
	    
	    $startdate = $class->timestarted;
	    $enddate = $class->timecompleted;*/
	   
	
	    /* Query to search all events that intersect with current */
	   	
	    $strsqlstring = "SELECT * FROM #__tlive_classes AS c	    				
	    				 WHERE id<>$classroom_id AND
	                     (timestarted<'$enddate' AND timecompleted>'$startdate') 
	                       ORDER BY timestarted, timecompleted ASC";	 
	                       
	       
	
	    /* Sliding window of aux array for comparison */
	    $count = 0;
	    $db->setQuery($strsqlstring);   
	    
	    
	    	   	
	    if ($res = $db->loadObjectList()) {
	        /* Nested loop that make comparisons between time interval, to count total participants */	        
	        
	
	        foreach ($res as $i) {
	            /* Subarray used to make comparisons between events */
	            $subarray = array_slice($res, $count+1, count($res));
	
	            $userscount=0;
	
	            foreach ($subarray as $j) {
	            	
	            	//$start = JFactory::getDate($j->timestarted,'UTC')->toUnix();
	            	//echo $start;
	            	
	            	$start = new DateTime($j->timestarted,new DatetimeZone('UTC'));
	            	//print_r($start);
	            	$end = new DateTime($i->timecompleted,new DatetimeZone('UTC'));
	            	//echo $start->toUnix();
	            	
	                //print_r($end);
	            	
	            	//die;
	
	                /* Checks if two time intervals intersect, then makes users partial sum */
	                if ($end > $start ) {
	                    /* somma parziale */
	                    $userscount = $userscount + $j->users;
	
	                }
	
	            }
	
	            /* Total sum */
	            $userscount = $userscount + $users + $i->users;
	            
	            	            	           
	
	            if ($userscount  > $maxusers) {
	                /* If total users is greater than max users, return false  */
	                //TliveHelper::setError(JText::_('COM_TLIVE_MESSAGE_ENROL_USERS_MAXUSERS_ERROR'));
	                TliveHelper::setError(JText::_('COM_TLIVE_MESSAGE_ENROL_USERS_MAXUSERS_ERROR'));                
	                return false;
	            }
	
	            $count++;
	
	        }
	        /* if there aren't any events that intersect the current */
	
	    } else {
	    	
	    		
	        if ($users > $maxusers) {
	            /* If total users is greater than max users, return false  */
	            TliveHelper::setError(JText::_('COM_TLIVE_MESSAGE_ENROL_USERS_MAXUSERS_ERROR'));
	            return false;
	
	        }
	    }
	
	    return true;
	}
	
	/**
	 * Function that builds XML server request
	 *
	 * @param	int $type Request type (see TVCL API documentation)
	 * @return	object SimpleXml Object
	 * @since	1.6
	 */
	
	public function createXML($type){
		
		//load config params
		$params = JComponentHelper::getParams('com_tlive');
		//load CCC
		$client_code = $params->get('client_code');							
		
		//-->Begin XML creation<--
		$XML= new SimpleXMLElement("<ews></ews>");
		$XML->addAttribute('type',$type);
		$XML->addChild('clientcode',$client_code);
		
		
		return $XML;	
		
		//--->End XML creation<----	
			
	
	}
	
	/**
	 * Function that builds XML request to create a room
	 *
	 * @param	object $data Form data
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	
	public function createRoom($data) {
		
		$XML = TliveHelper::createXML(1);
		
		/* build unixtime timestamp (UTC), considering user timezone */				
		$user = JFactory::getUser();
		$config = JFactory::getConfig();		
    	$timezone = $user->getParam('timezone', $config->get('offset'));    
    	$params = JComponentHelper::getParams('com_tlive');	
    	$users = $data['users'];
    	
    	//$day = JFactory::getDate($data['day'],$timezone); 
    	/* offset da sottrarre nel computo dei secondi (le ore selezionate sono quelle rispetto all'ora locale dell'utente */
    	//$offset = $day->getOffsetFromGMT(); 
    	
    	
    	/* riportiamo l'orario dell'utente in UTC */
    	//$day->setTimeZone(new DateTimeZone('UTC'));   	
    		 	
    	
		/* conversione in timestamp per aggiungere poi i minuti e secondi */
    	//$day = $day->toUnix();        		
    	
    	//$timestarted = $day + $data['start_hour']*3600 + $data['start_mins']*60 - $offset;    	
    	//$timecompleted = $day + $data['close_hour']*3600 + $data['close_mins']*60 - $offset;   	
    	    	
		
		//$timestarted = gmdate('Y-m-d H:i:s',$timestarted);
		//$timecompleted = gmdate('Y-m-d H:i:s',$timecompleted);	
		
		$timestarted = ((int)$params->get('disable_date')==0) ?  $data['timestarted'] : '';
		$timecompleted = ((int)$params->get('disable_date') == 0 ) ?  $data['timecompleted'] : '';
		
				
		$XML->addChild('users',$users);
		$XML->addChild('startdate',$timestarted);
	    $XML->addChild('enddate',$timecompleted);
		$XML->addChild('title',$data['title']);
		
		
		if(!empty($data['logo'])) {
			
			$XML->addChild('logo',JURI::root().$data['logo']);
		
		}	
		
		if(!empty($data['banner'])) {
			
			$XML->addChild('banner',JURI::root().$data['banner']);
		
		}	
						
		
		$XMLResponse = TliveHelper::getXMLResponse($XML);
		
		return $XMLResponse;
		
		
	}
	
	/**
	 * Function that builds XML request to edit a room
	 *
	 * @param	object $data Form data
	 * @param	int $roomid Room id
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	public function editRoom($data,$roomid) {
		
		$XML = TliveHelper::createXML(6);		
		$XML->addChild('roomid',$roomid);	
		
		
		/* build unixtime timestamp (UTC), considering user timezone */			
		$user = JFactory::getUser();
		$config = JFactory::getConfig();		
		$params = JComponentHelper::getParams('com_tlive');	
    	$timezone = $user->getParam('timezone', $config->get('offset'));   
    	$users = $data['users']; 		
    	
    	//$day = JFactory::getDate($data['day'],$timezone); 
    	/* offset da sottrarre nel computo dei secondi (le ore selezionate sono quelle rispetto all'ora locale dell'utente */
    	//$offset = $day->getOffsetFromGMT(); 
    	
    	
    	/* riportiamo l'orario dell'utente in UTC */
    	//$day->setTimeZone(new DateTimeZone('UTC'));   	
    		 	
    	
		/* conversione in timestamp per aggiungere poi i minuti e secondi */
    	//$day = $day->toUnix();        		
    	
    	//$timestarted = $day + $data['start_hour']*3600 + $data['start_mins']*60 - $offset;    	
    	//$timecompleted = $day + $data['close_hour']*3600 + $data['close_mins']*60 - $offset;   	
    	    	
		
		//$timestarted = gmdate('Y-m-d H:i:s',$timestarted);
		//$timecompleted = gmdate('Y-m-d H:i:s',$timecompleted);
		
		$timestarted = ((int)$params->get('disable_date') == 0) ?  $data['timestarted'] : '';
		$timecompleted = ((int)$params->get('disable_date') == 0 ) ?  $data['timecompleted'] : '';
		
		$XML->addChild('users',$users);
		$XML->addChild('startdate',$timestarted);
	    $XML->addChild('enddate',$timecompleted);
		$XML->addChild('title',$data['title']);		
		
					
		if(!empty($data['logo'])) {
			
			$XML->addChild('logo',JURI::root().$data['logo']);
		
		}	
		
		if(!empty($data['banner'])) {
			
			$XML->addChild('banner',JURI::root().$data['banner']);
		
		}		
		
				
		$XMLResponse = TliveHelper::getXMLResponse($XML);
		
		return $XMLResponse;
			

	}
	
	/**
	 * Function that builds XML request to delete a room
	 *	 
	 * @param	int $roomid Room id
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	public function deleteRoom($roomid) {
		
		$XML = TliveHelper::createXML(2);
		$XML->addChild('roomid',$roomid);
		
		$XMLResponse = TliveHelper::getXMLResponse($XML);
		
		return $XMLResponse;
		
		
		
	}
	
	/**
	 * Function that builds XML request to enable user room access
	 *	 
	 * @param	object $data Form data
	 * @param	int $roomid Room id
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	public function enableUser($data,$roomid) {
		
		$XML = TliveHelper::createXML(3);
		$XML->addChild('roomid',$roomid);
		
		// load user language
		$taglang =  JFactory::getLanguage();
		$lang = strtoupper(substr($taglang->getTag(),0,2));
		
		/*switch($taglang->getTag())	{
			case "es-ES": 
				$lang="ES";
				break;
			case "en-GB": 
				$lang="EN";
				break;
			default: 
				$lang="IT";
		}*/
			
		
		$XML->addChild('lmsuserid',$data['lmuserid']);
		$XML->addChild('role',$data['role']);
	    $XML->addChild('name',$data['name']);
		$XML->addChild('email',$data['email']);
		$XML->addChild('lang',$lang);		
		
		
		$XMLResponse = TliveHelper::getXMLResponse($XML);
		
		return $XMLResponse;
		
		
	}
	
	/**
	 * Function that builds XML request to get room's logs
	 *	 
	 * @param	int $roomid Form data
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	public function getRoomLogs($roomid) {
		
		$XML = TliveHelper::createXML(16);	
		$XML->addChild('roomid',$roomid);
		$XML->addChild('full',1);
		
		$XMLResponse = TliveHelper::getXMLResponse($XML);	
		
		
		return $XMLResponse;
		
		
	}
	
	/**
	 * Function that sends server request
	 *	 
	 * @param	int $roomid Form data
	 * @return	object SimpleXml Object Server response
	 * @since	1.6
	 */
	public function getXMLResponse($XML) {
		
		//Load TVCL server URL
		$params = JComponentHelper::getParams('com_tlive');
		$url_tvcl = $params->get('url_tvcl');	
		
		//Send XML request and receive server response
		$ch = curl_init($url_tvcl);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $XML->asXML());
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_REFERER, 'http://www.teleskill.net');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$ch_response = curl_exec($ch);		
		$ch_info = curl_getinfo($ch);		
		
		if ($ch_info['http_code'] != 200) {
			
			$ch_response = '';
			
		}
		
		//print_r($XML->asXML());		
		
		curl_close($ch);
		
		$XMLResponse = simplexml_load_string($ch_response);
		
		//echo $XML->asXML();
		
		return $XMLResponse;		
		
		
	}	
	
	
	
	
	/**
      * Method to return a list of actions for which permissions can be set given a component and section.
      * @param $messageId Message id
      * @return List of actions available for the given component and section.
      * @since	1.6
      */
      public static function getActions($messageId = 0) {      	
      	
      	jimport('joomla.access.access');
        $user   = JFactory::getUser();
        $result = new JObject;

        if (empty($messageId)) {
                $assetName = 'com_tlive';
        }
        else {
                $assetName = 'com_tlive.message.'.(int) $messageId;
        }

        $actions = JAccess::getActions('com_tlive', 'component');

        foreach ($actions as $action) {
                $result->set($action->name, $user->authorise($action->name, $assetName));
        }

        return $result;
		
	}
	
	/**
	 * Function that builds an html access list
	 *	 
	 * @param	int $type Two types of sessions: Lesson or Room sessions 
	 * @param	int $id Lesson session or Room session
	 * @return	string  Html table
	 * @since	1.6
	 */
	public function buildtableaccess($type,$id) {
 		
 		$db = JFactory::getDbo();  
	    	
	    $heading_user = JText::_('COM_TLIVE_HEADING_PARTICIPANT_NAME');  
	    $heading_start = JText::_('COM_TLIVE_HEADING_CLASS_START');  
	    $heading_end =  JText::_('COM_TLIVE_HEADING_CLASS_FINISH');  
 		
		$table_users_sessions = new stdClass();
		$table_users_sessions->class = 'user_sessions';
		$table_users_sessions->head  = array($heading_user,$heading_start,$heading_end);
		$table_users_sessions->rowclasses = array();
		$table_users_sessions->data = array();
		$table_users_sessions->title = JText::_('COM_TLIVE_HEADING_ROOMSESSION_ACCESS');

		
		// Two types of sessions: Lesson or Room sessions 
		switch($type){	
					
			case 'lessonaccess':								
			$query = "SELECT uls.sessionid, u.name, uls.startdate, uls.enddate, us.roleid, us.ipaddress,ls.startdate AS sessionstart,ls.enddate AS sessionend
					FROM #__tlive_lesson_user_sessions AS uls
					INNER JOIN #__tlive_user_sessions AS us ON uls.usersessionid=us.usersessionid
					INNER JOIN #__tlive_lesson_sessions AS ls ON uls.lessonsessionid=ls.lessonsessionid
					INNER JOIN #__users AS u ON us.iduser=u.id
					WHERE uls.lessonsessionid=$id";		
			break;
			
			case 'roomaccess':
			$query = "SELECT u.name,us.startdate,us.enddate,rs.startdate AS sessionstart,rs.enddate AS sessionend 
						FROM #__tlive_user_sessions AS us
						INNER JOIN #__tlive_rooms_sessions AS rs ON us.roomsessionid=rs.roomsessionid
						INNER JOIN #__users AS u ON us.iduser=u.id
						WHERE us.roomsessionid=$id";		
						
			break;
		
		}
		       	      	    	        	
	        
	  	$db->setQuery($query);
	  	if ($user_sessions = $db->loadObjectList() ){            
	    	
	    		    	
	    	$table_users_sessions->title.= ' - '.
	    	JText::sprintf('COM_TLIVE_ROOMSESSION_DESC',
		  	JHtml::_('date', $user_sessions[0]->sessionstart, JText::_('DATE_FORMAT_LC3')),
		  	JHtml::_('date', $user_sessions[0]->sessionstart, 'H:i'),
		  	JHtml::_('date', $user_sessions[0]->sessionend, 'H:i'));	   	       	
	    		       	                                
	        foreach ($user_sessions as $u){		        	
	        	
	        	
	        	$user_text = $u->name;      	
	    		$start = JHtml::_('date', $u->startdate, JText::_('DATE_FORMAT_LC2'));
	    		//$start = $u->startdate;
	    		$end = JHtml::_('date', $u->enddate, JText::_('DATE_FORMAT_LC2'));
	    		//$end = $u->enddate;	    		
	        	$aux = array($user_text,$start,$end);	        	
	        	     		        	
	        	array_push($table_users_sessions->data,$aux);
	        
	                        	
	        }
	        
	        	        
		 }	
		 
		
		return $table_users_sessions;	 
 		
 	}
 	
 	/**
	 * Function that builds an html access list
	 *	 
	 * @param	int $id Poll id
	 * @return	object Poll data
	 * @since	1.6
	 */
 	public function buildtablepolls($id) {   	
    		    	    
	    //intestazioni tabella
	    $heading_user = JText::_('COM_TLIVE_HEADING_PARTICIPANT_NAME'); 	    
	    $heading_answer = JText::_('COM_TLIVE_HEADING_POLLSESSION_ANSWER'); 	  
	    $heading_correct = JText::_('COM_TLIVE_HEADING_POLLSESSION_RESULT'); 	 
    	
    
	    $table = new stdClass();
		$table->class = 'user_answers';
		$table->head  = array($heading_user,$heading_answer,$heading_correct);
		$table->rowclasses = array();
		$table->data = array();
		
		
		$db = JFactory::getDbo();
		
			
					
		$query = "SELECT upa.userspollanswerid, u.name,u.id as userid, ps.correct, us.roleid,
				 p.question,ps.answer, us.startdate, us.enddate,pss.opendate,pss.closedate
				 FROM (#__tlive_users_poll_answers AS upa
				 INNER JOIN #__tlive_user_sessions AS us ON upa.usersessionid=us.usersessionid
				 INNER JOIN #__tlive_polls_answers AS ps ON upa.answerid=ps.answerid
				 INNER JOIN #__tlive_polls_sessions AS pss ON upa.pollsessionid=pss.pollsessionid
				 INNER JOIN #__tlive_polls AS p ON pss.pollid=p.pollid
				 )
				 INNER JOIN #__users as u ON us.iduser = u.id
				 WHERE upa.pollsessionid=$id";	
				 			
		$db->setQuery($query);
					 		
 		if ($result = $db->loadObjectList() ){
 			
 			$table->title = JText::_('COM_TLIVE_HEADING_POLLSESSION_QUESTION').': '.$result[0]->question.', '.
 			JText::sprintf('COM_TLIVE_ROOMSESSION_DESC',
		  	JHtml::_('date', $result[0]->opendate, JText::_('DATE_FORMAT_LC3')),
		  	JHtml::_('date', $result[0]->opendate, 'H:i'),
			JHtml::_('date', $result[0]->closedate, 'H:i'));
 						
 			foreach ($result as $r){
 				
 				if($r->correct==1){
 					$correct = JText::_('COM_TLIVE_HEADING_POLLSESSION_ANSWER_CORRECT');
 					}else {
 						$correct = JText::_('COM_TLIVE_HEADING_POLLSESSION_ANSWER_WRONG');
 					}	 					
 								
 				$row = array($r->name,$r->answer,$correct);
 				array_push($table->data,$row);
 				
 			}
 			
 			
 		}
	 		
	 	 return $table;
 		
 	}
 	
 	/**
	 * Function that export report in a Excel document
	 *	 
	 * @param	object $table Report data
	 * @return	void
	 * @since	1.6
	 */
 	public function exportxls($table){ 		
 				 		

		/** PHPExcel */
		require_once(JPATH_COMPONENT_ADMINISTRATOR."/libraries/PHPExcel/PHPExcel.php");

		/** PHPExcel_Writer_Excel2007 */
		require_once(JPATH_COMPONENT_ADMINISTRATOR."/libraries/PHPExcel/PHPExcel/Writer/Excel2007.php");
		
		//new object
		$objPHPExcel = new PHPExcel();			
		$objPHPExcel->setActiveSheetIndex(0);
		$worksheet = $objPHPExcel->getActiveSheet();
		$worksheet->setShowGridlines(true);
			
			
		for ($col = 'A'; $col != 'Z'; $col++) {
			$objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
		}
		
		$worksheet->setCellValue('A1',$table->title);
		$worksheet->getStyle('A1')->getFont()->setBold(true);
		$worksheet->getStyleByColumnAndRow('A1')->getFont()->setSize(16);
		$worksheet->mergeCells('A1:Z1');
		
		
			
	    $column = 0;
	    $row = 3;
	    
	    
	   
		foreach ($table->head as $h){
			
			
			$worksheet->setCellValueByColumnAndRow($column,$row,strip_tags($h));
			$worksheet->getStyleByColumnAndRow($column,$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID); 
			$worksheet->getStyleByColumnAndRow($column,$row)->getFill()->getStartColor()->setRGB('cc1111'); 
			$worksheet->getStyleByColumnAndRow($column,$row)->getFont()->setBold(true);
			$worksheet->getStyleByColumnAndRow($column,$row)->getFont()->setSize(14);
			$worksheet->getStyleByColumnAndRow($column,$row)->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);						
			
			$column++;							
							
		}
		
		$row++;			
					
		foreach($table->data as $data){
			
			$column = 0;
			
			if($row % 2!=0){
			$color = "bce7ff";} 
			else {
			$color = "ffffff";
			}
			
			foreach($data as $d){
				
   				$worksheet->setCellValueByColumnAndRow($column,$row,$d);
   				$worksheet->getStyleByColumnAndRow($column,$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID); 
				$worksheet->getStyleByColumnAndRow($column,$row)->getFill()->getStartColor()->setRGB($color); 
				$worksheet->getStyleByColumnAndRow($column,$row)->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);		
							 
									
				$column++;
				   					
				
			}
			
			$row++;	
		
		}

					
		$worksheet->setTitle('export');	
		
		ob_end_clean();
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="export.xls"');
		header('Cache-Control: max-age=0');
		$objWriter->save('php://output');
		
		exit;
	
 	}
 	
 	/**
	 * Function for parses table data and builds an html table
	 *	 
	 * @param	object $table Table data
	 * @return	string  Html table
	 * @since	1.6
	 */
 	public function buildhtmltable($table){   		
   		
   		$html="<p></p>
   		<table border=\"1\">
   		<tr style=\"font-size: large;\" bgcolor=\"#cc1111\">";
   		
   		foreach ($table->head as $h){
   			$html.="<td>$h</td>";
   		}
   		
   		$html.='</tr></thead>
   		<tbody>';
   		$count=1;
   		
   		foreach ($table->data as $data){
   			
   			if($count % 2==0){
   				$color = "#bce7ff";
   			}else {
   				$color = "#ffffff";
   			}
   			
   			$html.="<tr bgcolor=\"$color\">";
   			
   			foreach($data as $d){
	   			$html.="<td>$d</td>";  
	   		}
	   		
	   		$html.="</tr>";
	   		
   			$count++;			
   		}
   		
   		$html.="</table>";  
   		
   		return $html; 			
   		
   	}
   	
   	/**
	 * Function that export report in a PDF document
	 *	 
	 * @param	object $table Table data
	 * @return	void
	 * @since	1.6
	 */
   	public function exportpdf($table){   		
   		    
   		
   		//caricamento libreria tcpdf
   		require_once(JPATH_COMPONENT_ADMINISTRATOR.'/libraries/tcpdf/tcpdf.php');   		
   		require_once(JPATH_COMPONENT_ADMINISTRATOR.'/libraries/tcpdf/lang/ita.php');
   		
   		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		// set default header data
		//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 048', PDF_HEADER_STRING);
		
		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		
		//set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		
		//set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		
		//set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		
		//set some language-dependent strings
		$pdf->setLanguageArray($l);
		
		// set font
		$pdf->SetFont('helvetica', 'B', 16);
		// add a page
		$pdf->AddPage();
		$title = $table->title;		
		$pdf->Write(0, $title, '', 0, 'L', true, 0, false, false, 0);		
		$pdf->SetFont('dejavusans', '', 8);		
   		  		
   		$html = TliveHelper::buildhtmltable($table);  		
   		 		
   		   		
   		$pdf->writeHTML($html, true, false, false, false, '');   		
   		$pdf->Output('export.pdf', 'D');
   	
   		
   	}
   	
   	/**
	 * Method to send email
	 *
	 * @param	array $recipient users emails list
	 * @param	string $subject email subject
	 * @param	string $body email body
	 * @return	void
	 * @since	1.6
	 */	
   	public function sendEmail($recipient,$subject,$body) {
		
		$config = JFactory::getConfig();
		$mailer = JFactory::getMailer();
		$mailer->isHTML(true);
		//$mailer->CharSet	= "ISO-8859-1";
		
		/* set sender */	
		$sender = array(
			$config->get('config.mailfrom'),
			$config->get('config.fromname')
		);
		
		$mailer->setSender($sender);
		$mailer->addRecipient($recipient);
		
		/* set subject */
		$mailer->setSubject($subject);
		
		/* set subject */
		$mailer->setBody($body);
		
		if (!$send = $mailer->Send()) {
			
			TliveHelper::setError('Impossibile inviare il messaggio');
		}
		
		
		
	}
   	
   	/**
	 * Method to set error property
	 *
	 * @param	string $error Error message	 
	 * @return	void
	 * @since	1.6
	 */	
   	public function setError($error) {
   		
   		$this->error = $error;
   		
   	} 
   	
   	/**
	 * Method to get error property
	 *
	 * @param	void 
	 * @return	$string Error
	 * @since	1.6
	 */	
   	public function getError() {
   		
   		return $this->error;
   		
   	} 
   	
	
		
}