<?php

jimport('joomla.application.component.modelitem');

/**
 * Model for the Joomla Tlive component.
 *
 * @package		Joomla.Site
 * @subpackage	com_tlive
 */
class TliveModelEventavailability extends JModelItem {
	
	protected $item;
	
	
	public function getItem() {	
		
		$params = JComponentHelper::getParams('com_tlive');
		$config = JFactory::getConfig();
		$user = JFactory::getUser();
		
		
		/* Load max users param */
		$maxusers = $params->get('max_users');
		$classroom_id = JRequest::getVar('update',0,'get','integer');
		$startdate = JRequest::getVar('startdate','','get','string');
		$enddate = JRequest::getVar('enddate','','get','string');
		$users = JRequest::getVar('users',0,'get','integer');
		
		/* Convert datetime string to unix time format */
		$timezone = $user->getParam('timezone', $config->get('offset'));
		
		/* If user time zone is not equal to server local time set default time zone as user time zone */
		/*if ($timezone!= $config->getValue('offset')) {
		    
		}*/
		
		date_default_timezone_set($timezone);
		  
		/* transform in epoch time */    
		$startdate = strtotime($startdate);
		$enddate = strtotime($enddate);
		
		/* transform UTC time in datetime format */
		$startdate = gmdate('Y-m-d H:i:s',$startdate);
		$enddate = gmdate('Y-m-d H:i:s',$enddate);
		
		
		/* verifies that date fields are valid */
		if (!empty($startdate) && !empty($enddate)) {
			
			$helper = new TliveHelper();
			$success = $helper->event_availability($startdate,$enddate,$maxusers, $users, $classroom_id);
		
		    
		} else {
		
		    $success = false;
		
		}
		
		/* Return json answer */
		$json = array(
			'success' =>$success
		);
				
		
		
		$this->item = $json;
		
		return $this->item;
	
		
		
		
		
		
		
	}
	
		
	
	
	
	
	
	
	
}