<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');

/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */
class JFormFieldMaxusers extends JFormField {

	protected $type = 'Maxusers';

	/* Method to get the input control for a field.
	 * return $string The form field input control.
	*/
	public function getInput() {

		/* Load last session form data */
		$sessionstate = JFactory::getApplication()->getUserState('com_tlive.edit.class.data',array());
		$users = isset($sessionstate['users']) ? $sessionstate['users'] : 1;


		$classid = JRequest::getVar('id',0,'get','int');
		$params = JComponentHelper::getParams('com_tlive');

		$db = JFactory::getDBO();
		$query = "SELECT id,users FROM #__tlive_classes WHERE id=$classid";
		$db->setQuery($query);

		/* If edit an existing room, load data from db */
		if( $result = $db->loadObject()) {

			$users = $result->users;

		}

		$input = '<select class="'.$this->fieldname.'" id="'.$this->name.'" name="'.$this->name.'">';
		$max = $params->get('max_users');

	    for($i=1;$i<=$max;$i++) {

			$selected = '';

			if (!empty($users) && $users == $i ) {

			 	$selected="selected";
			}

			$input.= "<option $selected value='$i'>$i</option>";
	    }


		$input.= '</select>';


		return $input;

	}




}