<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
defined('_JEXEC') or die('Restricted access'); 
jimport('joomla.form.formfield');
 
/**
 * @package     Joomla.Administrator
 * @subpackage  com_tlive
 * @since       1.6
 */
class JFormFieldTimeselect extends JFormField {
	
	protected $type = 'Timeselect';
	
	/* Method to get the input control for a field.
	 * return $string The form field input control.
	*/
	public function getInput() {		
		 
		$user = JFactory::getUser();    	
    	$config = JFactory::getConfig();
    	$date = '';
    	
    	/* Load last session form data */
    	$timestarted = '';
    	$timecompleted = '';
    	
		$sessionstate = JFactory::getApplication()->getUserState('com_tlive.edit.class.data',array());
		
		if(!empty($sessionstate)) {		
			$timestarted = $sessionstate['start_hour'].':'.$sessionstate['start_mins'];
			$timecompleted = $sessionstate['close_hour'].':'.$sessionstate['close_mins'];
		}	
    	
    	$db = JFactory::getDbo();    	
		//$date = $this->value;
		
		/* If edit an existing room, load data from db */
		$id = JRequest::getVar('id',0,'get','integer');			
		$db->setQuery("SELECT * FROM #__tlive_classes WHERE id=$id");
		
		if($res = $db->loadObject()) {	
			
			$timestarted = $res->timestarted;
			$timecompleted = $res->timecompleted;
	
			
		}
		
		switch ($this->fieldname) {
				case 'start':				
				$date = $timestarted;
				break;
				
				case 'close': 
				$date = $timecompleted;
				break;				
				
		}
		
		if($res) {	
			// Use UTC timezone when load from db
			$timezone = 'UTC';
        	
        } else {
        	// otherwise use user timezone
        	$timezone = $user->getParam('timezone', $config->get('offset'));
        }
        
        // Get a date object based on timezone
        $day = JFactory::getDate($date, $timezone);

        // Set the correct time zone based on the user configuration.
        $day->setTimeZone(new DateTimeZone($user->getParam('timezone', $config->get('offset'))));	
					
		$dayhour = (int) $day->format('H',true);
		
		/* When create a new room, set default close hour = start hour + 1  */
		if(empty($timecompleted) && $this->fieldname == 'close') {
			
			$dayhour++;
		}
		
		
        $input = '<select id="'.$this->name.'" name="jform['.$this->fieldname.'_hour]">';
        
        for ($i=0; $i<24; $i++) {
        	
        	$selected = ($i == $dayhour ) ? 'selected' : '';     	
        	
        	        	
        	$hour = str_pad($i, 2, "0", STR_PAD_LEFT);        	
            $input.= '<option '.$selected.' value="'.$hour.'">'.$hour.'</option>';
            
        }
	 			 
	 			  
	 	$input.= '</select>'; 	
	 	
	 	
	 	$input.= '<select id="'.$this->name.'" name="jform['.$this->fieldname.'_mins]">';
	 	
	 	for ($i=0; $i<60; $i+=5) {
	 		
	 		$selected = ($i == $day->format('i',true) ) ? 'selected' : '';	
	 		
	 	    $mins = str_pad($i, 2, "0", STR_PAD_LEFT); 	
            $input.= '<option '.$selected.' value="'.$mins.'">'.$mins.'</option>';
        }
        
       	$input.= '</select>'; 	
                   

		
		return $input;
		
	}
	
	


}