<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.modeladmin');

class TliveModelSavereports extends JModelAdmin {
  
  /**
	 * Method to get the row form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */	
	  public function getForm($data = array(), $loadData = true) {
	    
	    // Get the form.
	    $form = $this->loadForm('com_tlive.class', 'class', array('control' => 'jform', 'load_data' => $loadData));
		return $form;
		
	  }	  
	 
	 /**
	 * Method to save to db room logs 
	 *
	 * @param  object $xmlstructure SimpleXml TVCL's response  
	 * @return  boolean
	 *
	 * @since   1.6
	*/
	function saveLogs($xmlstructure) {		
		
		
		$db = JFactory::getDbo();
			
	    //$xmlstructure = simplexml_load_string($xmlanswer);
	    /* Statistics are passed by Tlive in Europe/Rome local time*/
	    date_default_timezone_set('Europe/Rome');	    
	      
	
	    if ($xmlstructure->Room) {
	
	        $room = $xmlstructure->Room;
	        $roomid = (int) $xmlstructure->Room->attributes()->ID;
	        
	        $query = "SELECT * FROM #__tlive_rooms WHERE roomid=$roomid";
	        $db->setQuery($query);			
	
	        if (!$result = $db->loadObject()) {
	        		
	            $query = "INSERT INTO #__tlive_rooms VALUES ('$roomid', 0)";
	            $db->setQuery($query);
	             
	            
	            if(!$db->execute() ) {  
            	          	
            		return false;	            	
            	}
            	
            	
	        }
	        
	        foreach ($room->RoomSession as $roomsession) {

	            $roomsessionid = (int)$roomsession->attributes()->ID;
	            $startdate = strtotime($roomsession->attributes()->StartDate);
	            $enddate = strtotime($roomsession->attributes()->EndDate);
	            
	            $query = "SELECT * FROM #__tlive_rooms_sessions WHERE roomsessionid=$roomsessionid";
	        	$db->setQuery($query);
	
	            if (!$result = $db->loadObject()) {
	            	
	                $query="INSERT INTO #__tlive_rooms_sessions VALUES ('$roomsessionid', '$roomid', '$startdate', '$enddate', '0')";
	
	                /* Notice: you can't use insert_record because primary key (roomid) is already defined,
	                 * use execute SQL */
	                $db->setQuery($query);
	                
	                if(!$db->execute() ) { 
	                	            	          	
            			return false;	            	
            		}
	            }
	
	            /* if polls sessions exist, save them */
	            if ($roomsession->Polls) {
	            	
	               	if( !$this->getpolls($roomsession->Polls, $roomsessionid)) {
	               			               	
	               		return false;
	            	}
	            }
	
	            /* if users sessions exist, save them */
	            if ($roomsession->UserSessions) {
	                
	                if(!$this->getusersessions($roomsession->UserSessions, $roomsessionid)) {
	                	
	                	return false;	
	                }
	            }
	
	            /* if lessions sessions exist, save them */
	            if ($roomsession->LessonSessions) {
	            	
	               if (!$this->getlessonsessions($roomsession->LessonSessions, $roomsessionid)) {
	               		               	
	               		return false;
	               		
	               }
	            }

           }
	        
	
	        
		}
		
		
		return true;
	}

	/**
	 * This function saves polls data to db, from polls simplexml object
	 *
	 * @param object $polls Polls data simplexml object
	 * @param int $roomsessionid Room session id
	 */
	function getpolls($polls, $roomsessionid) {
	
	    $db = JFactory::getDbo();	
	
	    foreach ($polls->Poll as $poll) {
	
	        $pollid = (int)$poll->attributes()->ID;
	        /* replace "?" and prevent any quotes */
	        $question = addslashes(str_replace("?",  '',  $poll->attributes()->Question));
	        
	        $query = "SELECT * FROM #__tlive_polls WHERE pollid=$pollid";
	        $db->setQuery($query);
	
	        if (!$result = $db->loadObject()) {
	        	
	            $query="INSERT INTO #__tlive_polls VALUES ('$pollid', '$question', '$roomsessionid')";
	            $db->setQuery($query);
	            if(!$db->execute() ) {  
	            	//echo '1';          	
	            	return false;	            	
	            }
	        }
	
	        if ($poll->Answers) {
	            if (!$this->getanswers($poll->Answers, $pollid)) {
	            	//echo '2';  
	            	return false;	
	            }
	        }
	
	        if ($poll->PollSessions) {
	        	if(!$this->getpollsessions($poll->PollSessions, $pollid)) {
	        		   //echo '3';       		
	        		return false;	
	        	}
	        }
	
	    }
	    
	    return true;
	
	}

	/**
	 * This function saves poll answers data to db, from answers simplexml object
	 *
	 * @param object $answers Answers simplexml object
	 * @param int $pollid Poll id
	 */
	function getanswers($answers, $pollid) {
	
	    $db = JFactory::getDbo();	
	
	    foreach ($answers->Answer as $answer) {
	
	        $answerid = (int)$answer->attributes()->ID;
	        $sequence = $answer->attributes()->Sequence;
	
	        $answerstr = addslashes(str_replace("?",  '', $answer->attributes()->Answer));
	        $correct = $answer->attributes()->Correct;
	        
	        $query = "SELECT * FROM #__tlive_polls_answers WHERE answerid=$answerid";
	        $db->setQuery($query);
	
	        if (!$result = $db->loadObject()) {        	
	        	
	            $query="INSERT INTO #__tlive_polls_answers VALUES ('$answerid', '$pollid', '$answerstr', '$sequence', '$correct')";
	            $db->setQuery($query);
	            if(!$db->execute() ) {  
	            	          	
	            	return false;	            	
	            }
	        }
	
	    }
	    
	    return true;
	
	}

	/**
	 * This function saves poll sessions data to db, from answers simplexml object
	 *
	 * @param object $pollsessions Answers simplexml object
	 * @param int $pollid Poll id
	 */
	function getpollsessions($pollsessions, $pollid) {
	
	    $db = JFactory::getDbo();	
	
	    foreach ($pollsessions->PollSession as $pollsession) {
	
	        $pollsessionid = (int)$pollsession->attributes()->ID;
	        $opendate = (int)strtotime($pollsession->attributes()->OpenDate);
	        $closedate = (int)strtotime($pollsession->attributes()->CloseDate);        
	        
	        $query = "SELECT * FROM #__tlive_polls_sessions WHERE pollsessionid=$pollsessionid";
	        $db->setQuery($query);           
	
	        if (!$result = $db->loadObject()) {
	        	
	            $query="INSERT INTO #__tlive_polls_sessions VALUES ('$pollsessionid', '$pollid', '$opendate', '$closedate')";
	            $db->setQuery($query);
	            if(!$db->execute() ) {  
	            	echo $db->getErrorMsg();      	
	            	return false;	            	
	            }
	        }
	
	        $useranswers = $pollsession->UserAnswer;
	        if (!$this->getuseranswers($useranswers, $pollsessionid) ) {
	        	return false;
	        	
	        }
	    }
	    
	    return true;
	}

	/**
	 * This function saves user answers data to db, from user answers simplexml object
	 *
	 * @param object $useranswers Answers simplexml object
	 * @param int $pollsessionid Poll session id
	 */
	function getuseranswers($useranswers, $pollsessionid) {
	
	    $db = JFactory::getDbo();
	
	    foreach ($useranswers as $useranswer) {
	
	        $useranswerid = (int)$useranswer->attributes()->ID;
	        $usersessionid = $useranswer->attributes()->UserSessionID;
	        $answerid = $useranswer->attributes()->AnswerID;
	        $creationdate = strtotime($useranswer->attributes()->CreationDate);
			
			$query = "SELECT * FROM #__tlive_users_poll_answers WHERE userspollanswerid=$useranswerid";
			$db->setQuery($query);
			
	        if (!$result = $db->loadObject()) {
	            $query="INSERT INTO #__tlive_users_poll_answers
	                    VALUES ('$useranswerid', '$pollsessionid', '$usersessionid', '$answerid', '$creationdate')";
	            $db->setQuery($query);        
	            if(!$db->execute() ) {  
	            	//echo '6';          	
	            	return false;	            	
	            }
	        }
	
	    }
	    
	    
	    return true;
	}

	/**
	 * This function saves user sessions data to db, from user sessions simplexml object
	 *
	 * @param object $usersessions Answers simplexml object
	 * @param int $roomsessionid Room session id
	 */
	function getusersessions($usersessions, $roomsessionid) {
	
	    $db = JFactory::getDbo();
	
	    foreach ($usersessions->UserSession as $usersession) {
	
	        $usersessionid = (int) $usersession->attributes()->ID;
	        $userid = $usersession->attributes()->UserID;
	        $roleid = $usersession->attributes()->RoleID;
	        $startdate = strtotime($usersession->attributes()->StartDate);
	        $enddate = strtotime($usersession->attributes()->EndDate);
	        
	        /* $ipaddress = $usersession->attributes()->IpAddress; */
			
			$query = "SELECT * FROM #__tlive_user_sessions WHERE usersessionid=$usersessionid";
			$db->setQuery($query);
			
	        if (!$result = $db->loadObject()) {
	            $query="INSERT INTO #__tlive_user_sessions
	                    VALUES ('$usersessionid', '$userid', '$roomsessionid', '$roleid', '$startdate', '$enddate', '')";
	            $db->setQuery($query);       
	            if(!$db->execute() ) {  
	            	          	
	            	return false;	            	
	            }
	        }
	    }
	    
	    return true;
	}

	/**
	 * This function saves lesson sessions data to db, from lesson sessions simplexml object
	 *
	 * @param object $lessonsessions Lesson sessions simplexml object
	 * @param int $roomsessionid Room session id
	 */
	function getlessonsessions($lessonsessions, $roomsessionid) {
	
	    $db = JFactory::getDbo();
	
	    foreach ($lessonsessions->LessonSession as $lessonsession) {
	
	        $lessonsessionid = (int) $lessonsession->attributes()->ID;
	        $lessonstartdate = strtotime($lessonsession->attributes()->StartDate);
	        $lessonenddate = strtotime($lessonsession->attributes()->EndDate);
	        $lessonduration = $lessonsession->attributes()->Duration;
	        
	        $query = "SELECT * FROM #__tlive_lesson_sessions WHERE lessonsessionid=$lessonsessionid";
	        $db->setQuery($query);
	
	        if (!$result = $db->loadObject()) {
	        	
	            $query="INSERT INTO #__tlive_lesson_sessions
	                    VALUES ('$lessonsessionid', '$roomsessionid', '$lessonstartdate', '$lessonenddate', '$lessonduration')";
	            $db->setQuery($query); 
	                  
	            if(!$db->execute() ) {  
	            	          	
	            	return false;	            	
	            }
	        }
	        
	        
	        if(!$this->setuserlessonsession($lessonsession, $roomsessionid)) {
	        	
	        	return false;	
	        	
	        }
	    }
	    
	    return true;
	   
	}

	/**
	 * This function compute the effective user lesson session, crossing user sessions data with lesson sessions data
	 * and save it to db
	 *
	 * @param object $lessonsession Lesson session simplexml object
	 * @param int $roomsessionid Room session id
	 */
	function setuserlessonsession($lessonsession, $roomsessionid) {
	
	    $db = JFactory::getDbo();
	
	    $lessonstartdate = strtotime($lessonsession->attributes()->StartDate);
	    $lessonenddate   = strtotime($lessonsession->attributes()->EndDate);
	    $lessonsessionid = (int)$lessonsession->attributes()->ID;
	
	    /* extract all users sessions */
	    $query = "SELECT * FROM #__tlive_user_sessions WHERE roomsessionid=$roomsessionid";
	    $db->setQuery($query); 
	    
	    if ($usersessions = $db->loadObjectList() ) {  	
	    	
	
	        /* for each user session check if it intersects lesson session, if true, save it to db */
	        foreach ($usersessions as $usersession) {
	
	            $cond1 = ($lessonstartdate>= $usersession->startdate && $lessonstartdate<=$usersession->enddate);
	            $cond2 = ($lessonenddate>= $usersession->startdate && $lessonenddate<=$usersession->enddate);
	            $cond3 = ($lessonstartdate<= $usersession->startdate && $lessonenddate>=$usersession->startdate);
	
	            if ( $cond1 || $cond2 || $cond3 ) {            	
	            	
	                /* save user lesson session  */
	                $userlessonsessionstart = max($lessonstartdate, $usersession->startdate);
	                $userlessonsessionend = min($lessonenddate, $usersession->enddate);
	                $usersessionid = $usersession->usersessionid;
	                $duration = $userlessonsessionend - $userlessonsessionstart;
					
					$query = "SELECT * FROM #__tlive_lesson_user_sessions WHERE lessonsessionid=$lessonsessionid AND usersessionid=$usersessionid";
					$db->setQuery($query);
	                
	                if (!$check = $db->loadObject() ) {              	
	                	           	
	                	$query ="INSERT INTO #__tlive_lesson_user_sessions
	                             VALUES (NULL, '$lessonsessionid', '$usersessionid',
	                                     '$userlessonsessionstart', '$userlessonsessionend', '$duration')";
	                    $db->setQuery($query);                
	                    
	                    if(!$db->execute() ) {  
	            	          	
	            			return false;	            	
	            		}
	                }
	            }
	        }
	    }
	    
	    
	    
	    return true;
	}
  
  
}
