DROP TABLE IF EXISTS `#__tlive_classes`;
DROP TABLE IF EXISTS `#__tlive_enrolments`;
DROP TABLE IF EXISTS `#__tlive_lesson_sessions`;
DROP TABLE IF EXISTS `#__tlive_lesson_user_sessions`;
DROP TABLE IF EXISTS `#__tlive_polls`;
DROP TABLE IF EXISTS `#__tlive_polls_answers`;
DROP TABLE IF EXISTS `#__tlive_polls_sessions`;
DROP TABLE IF EXISTS `#__tlive_rooms`;
DROP TABLE IF EXISTS `#__tlive_rooms_sessions`;
DROP TABLE IF EXISTS `#__tlive_users_poll_answers`;
DROP TABLE IF EXISTS `#__tlive_user_sessions`;


CREATE TABLE IF NOT EXISTS `#__tlive_classes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `timestarted` datetime DEFAULT NULL,
  `timecompleted` datetime DEFAULT NULL,
  `roomid` int(10) DEFAULT 0,
  `logo` varchar(255) DEFAULT NULL,
  `banner` varchar(255) DEFAULT NULL,
  `users` int(10) DEFAULT 0,
  `auto_enrol` int(1) NOT NULL DEFAULT 0,
  `emailconfman` int(1) NOT NULL DEFAULT 0,
  `emailusers` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__tlive_enrolments` (
  `classroom_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `role` int(1) NOT NULL,
  PRIMARY KEY (`user_id`,`classroom_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_lesson_sessions` (
  `lessonsessionid` int(10) NOT NULL,
  `roomsessionid` int(10) DEFAULT NULL,
  `startdate` int(10) DEFAULT '0',
  `enddate` int(10) DEFAULT '0',
  `duration` int(10) DEFAULT '0',
  PRIMARY KEY (`lessonsessionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_lesson_user_sessions` (
  `sessionid` int(10) NOT NULL AUTO_INCREMENT,
  `lessonsessionid` int(10) DEFAULT NULL,
  `usersessionid` int(10) DEFAULT NULL,
  `startdate` int(10) DEFAULT '0',
  `enddate` int(10) DEFAULT '0',
  `duration` int(10) DEFAULT NULL,
  PRIMARY KEY (`sessionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_polls` (
  `pollid` int(10) NOT NULL,
  `question` longtext COLLATE utf8_unicode_ci,
  `roomsessionid` int(10) DEFAULT '0',
  PRIMARY KEY (`pollid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_polls_answers` (
  `answerid` int(10) NOT NULL,
  `pollid` int(10) DEFAULT NULL,
  `answer` longtext COLLATE utf8_unicode_ci,
  `sequence` int(10) DEFAULT '0',
  `correct` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`answerid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_polls_sessions` (
  `pollsessionid` int(10) NOT NULL,
  `pollid` int(10) DEFAULT NULL,
  `opendate` int(10) DEFAULT '0',
  `closedate` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pollsessionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_rooms` (
  `roomid` int(10) NOT NULL,
  `synchronized` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`roomid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_rooms_sessions` (
  `roomsessionid` int(10) NOT NULL,
  `roomid` int(10) DEFAULT NULL,
  `startdate` int(10) DEFAULT '0',
  `enddate` int(10) DEFAULT '0',
  `duration` int(10) DEFAULT NULL,
  PRIMARY KEY (`roomsessionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_users_poll_answers` (
  `userspollanswerid` int(10) NOT NULL,
  `pollsessionid` int(10) DEFAULT NULL,
  `usersessionid` int(10) DEFAULT NULL,
  `answerid` int(10) DEFAULT NULL,
  `creationdate` int(10) DEFAULT '0',
  PRIMARY KEY (`userspollanswerid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__tlive_user_sessions` (
  `usersessionid` int(10) NOT NULL,
  `iduser` int(10) DEFAULT NULL,
  `roomsessionid` int(10) DEFAULT NULL,
  `roleid` int(10) DEFAULT NULL,
  `startdate` int(10) DEFAULT '0',
  `enddate` int(10) DEFAULT '0',
  `ipaddress` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`usersessionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;