<?php
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */ 
 
// No direct access to this file
defined('_JEXEC') or die; 
jimport('joomla.application.component.view');

/**
 * View class to display poll session
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */
class TliveViewPollsession extends JViewLegacy {
	
	protected $items;
	protected $question;
	protected $opendate;
	protected $closedate;

/**
   * Display the view
   *
   * @return	void
    */	
  public function display($tpl = null) { 
  	
  	$pollsessionid = JRequest::getVar('id',0,'get','int');
  	$db = JFactory::getDbo();
  	$db->setQuery("SELECT p.question,ps.opendate,ps.closedate FROM #__tlive_polls_sessions AS ps
  	   INNER JOIN #__tlive_polls AS p ON ps.pollid=p.pollid
  	   WHERE ps.pollsessionid=$pollsessionid");  
  	$this->question = $db->loadObject()->question;
    $this->opendate = $db->loadObject()->opendate;  
    $this->closedate = $db->loadObject()->closedate;
    
    $items = $this->get('Items'); 
    $this->items = $items;
    
    $lang =  JFactory::getLanguage()->getTag();    
		
  	$document = JFactory::getDocument();
    $document->addStyleSheet('components/com_tlive/assets/css/classes.css');
    $document->addScript('components/com_tlive/assets/js/charts/jquery-1.9.1.min.js');
    $document->addScript('components/com_tlive/assets/js/charts/highcharts.js');
    $document->addScript('components/com_tlive/assets/js/charts/answers-chart-pie.js');
    $document->addScript('components/com_tlive/assets/js/lang/'.$lang.'.js');
    // Set the toolbar
    $this->addToolBar();
 
    // Display the template
    parent::display($tpl);
    
    
  }
 
 
 /**
   * Add the page title and toolbar.
   *
   * @since	1.6
  */
  protected function addToolBar() {
  	
    JRequest::setVar('hidemainmenu', true);
    JToolBarHelper::title(JText::_('COM_TLIVE_MANAGER_TITLE_POLL_SESSION'),'statistics');
    JToolBarHelper::custom( 'pollsession.saveexcel', 'excel', '', JText::_('COM_TLIVE_EXPORT_EXCEL'),false,false);
    JToolBarHelper::custom( 'pollsession.savepdf', 'pdf', '', JText::_('COM_TLIVE_EXPORT_PDF'),false,false);
    JToolBarHelper::back();
  
  }
}
