<?php 
/**
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */ 
 
// No direct access to this file
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

/**
 * View class to display poll sessions
 *
 * @package		Joomla.Administrator
 * @subpackage	com_tlive
 * @since		1.6
 */
class TliveViewPollsessions extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $canDo;

/**
   * Display the view
   *
   * @return	void
    */		
  function display($tpl = null) 
  {
    // Get data from the model
    $items = $this->get('Items');
    $pagination = $this->get('Pagination');
 
    // Assign data to the view
    $this->items = $items;
    $this->pagination = $pagination;
	
	$document = JFactory::getDocument();
    $document->addStyleSheet('components/com_tlive/assets/css/classes.css');
                
    // Set the toolbar
    $this->addToolBar();
 
    // Display the template
    parent::display($tpl);
  }
  
   /**
   * Add the page title and toolbar.
   *
   * @since	1.6
  */      
  protected function addToolBar() 
  {
  	require_once JPATH_COMPONENT . '/helpers/tlive.php';
  	$helper = new TliveHelper;
	$this->canDo = $helper->getActions();  	
  	
    JToolBarHelper::title(JText::_('COM_TLIVE_MANAGER_TITLE_POLL_SESSIONS'),'pie');
	JToolBarHelper::back();
	//TliveHelper::addSubmenu('classes');
  }      
}
?>
