<?php
/**
 * @package		Joomla.Site
 * @subpackage	com_tlive
 * @author	    Teleskill Italia S.r.l - 2014
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modelitem');

/**
 * @package     Joomla.Site
 * @subpackage  com_tlive
 * @since       1.6
 */
class TliveModelClass extends JModelItem {
  
  protected $item;
  
/** Method that return an item 
 * @return object Item object
 *
 */
  
	public function getItem()  {

		if (!isset($this->item)) {

			$id = JRequest::getInt('id');
			// Get a TableObject instance
			$table = $this->getTable('Classes', 'TliveTable');
			// Load the object
			$table->load($id);

			// Assign the data
			$roomid = $table->roomid;


			$lmuserid = 0;
			$role = 0;
			$name = '';
			$email = '';
			$lang = '';

			$user = JFactory::getUser();
			$db = JFactory::getDBO();

			$query="SELECT role FROM #__tlive_enrolments WHERE user_id='$user->id' AND classroom_id='$id'";
			$db->setQuery($query);
			$result = $db->loadObject();

			/* if user is enrolled, load data */
			if ($result) {

				$lmuserid = $user->id;
				$role = $result->role;
				$name = $user->name;
				$email = $user->email;
				// load user language
				$taglang = & JFactory::getLanguage();
				$lang = strtoupper(substr($taglang->getTag(),0,2));

			/* else first check if auto enrol is enabled, then enable user access */
			} else {

				if ($user->id != 0 && $table->auto_enrol) {

					/* enrol as participant */
				 	$role = 1;
				  	$query="INSERT INTO #__tlive_enrolments (classroom_id,user_id,role) VALUES ('$id','$user->id','$role')";
				  	$db->setQuery($query);
				  	$db->query();

				  	$lmuserid = $user->id;
					$name = $user->name;
					$email = $user->email;
					// load user language
					$taglang = & JFactory::getLanguage();
					$lang = strtoupper(substr($taglang->getTag(),0,2));


				}


			}			

			/* Login required */
  			$app = JFactory::getApplication();

		  	if (JFactory::getUser()->id == 0) {

		  		$loginUrl = 'index.php?option=com_users&view=login';
		  		$returnUrl = 'index.php?option=com_tlive&view=class&id='.$id;

		  		$app->redirect(JRoute::_($loginUrl.'&return='.base64_encode(urlencode($returnUrl)), false),JText::_('JGLOBAL_YOU_MUST_LOGIN_FIRST'),'warning');
		  		return false;

		  	}

		  	/* check if user has permission to access */
		  	if($lmuserid == 0) {

		  		JError::raiseWarning( 100, JText::_('COM_TLIVE_CLASSES_ACCESS_DENIED'));
		  		return false;

		  	}
		  	
		  	$data = array (    
			   	 "lmuserid" => $lmuserid,
			     "role"     => $role,
			     "name"     => $name,
			     "email"    => $email,
			     "lang"     => $lang,    
    		);         
    
    		$curlResponse = TliveHelper::enableUser($data,$roomid);   
	   
			if(!empty($curlResponse) && isset($curlResponse->errorcode) ) {
		          
			    if ((int)$curlResponse->errorcode == 0){
			    	
			    	$this->item['url'] = $curlResponse->url;
			    	
			    } else {
			    	
			    	JError::raiseWarning( 100, JText::_('COM_TLIVE_CLASSES_ACCESS_DENIED'));
		  			return false;		    	
			    	
			    
			    }
			} else {				
				
				JError::raiseWarning( 100, JText::_('COM_TLIVE_CLASSES_ACCESS_DENIED'));
		  		return false;				
				
			}

		}

		return $this->item;

	}


}
?>
