<?php // $Id: backuplib.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/**
 * Code fragment to define the backup of webskill
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

    //This function executes all the backup procedure about this mod
    function webskill_backup_mods($bf,$preferences) {
        global $CFG;

        $status = true;

        ////Iterate over webskill table
        if ($webskills = get_records ('webskill','course', $preferences->backup_course,'id')) {
            foreach ($webskills as $webskill) {
                if (backup_mod_selected($preferences,'webskill',$webskill->id)) {
                    $status = webskill_backup_one_mod($bf,$preferences,$webskill);
                }
            }
        }
        return $status;
    }

    function webskill_backup_one_mod($bf,$preferences,$webskill) {

        global $CFG;

        if (is_numeric($webskill)) {
            $webskill = get_record('webskill','id',$webskill);
        }

        $status = true;

        //Start mod
        fwrite ($bf,start_tag('MOD',3,true));
        //Print webskill data
        fwrite ($bf,full_tag('ID',4,false,$webskill->id));
        fwrite ($bf,full_tag('MODTYPE',4,false,'webskill'));
        fwrite ($bf,full_tag('COURSE',4,false,$webskill->course));
        fwrite ($bf,full_tag('NAME',4,false,$webskill->name));
        fwrite ($bf,full_tag('INTRO',4,false,$webskill->intro));
        fwrite ($bf,full_tag('INTROFORMAT',4,false,$webskill->introformat));

        fwrite ($bf,full_tag('ROOMID',4,false,$webskill->roomid));
        fwrite ($bf,full_tag('CONFMANID',4,false,$webskill->confmanid));
        fwrite ($bf,full_tag('EMAILCONFMAN',4,false,$webskill->emailconfman));
        fwrite ($bf,full_tag('STARTDATE',4,false,$webskill->startdate));
        fwrite ($bf,full_tag('ENDDATE',4,false,$webskill->enddate));
        fwrite ($bf,full_tag('OPENTOBLANK',4,false,$webskill->opentoblank));
        fwrite ($bf,full_tag('TITLE',4,false,$webskill->title));
        fwrite ($bf,full_tag('DESCR',4,false,$webskill->descr));
        fwrite ($bf,full_tag('USERS',4,false,$webskill->users));
        fwrite ($bf,full_tag('LOGO',4,false,$webskill->logo));
        fwrite ($bf,full_tag('SKIN',4,false,$webskill->skin));

        fwrite ($bf,full_tag('TIMECREATED',4,false,$webskill->timecreated));
        fwrite ($bf,full_tag('TIMEMODIFIED',4,false,$webskill->timemodified));

        //End mod
        $status = fwrite ($bf,end_tag('MOD',3,true));

        return $status;
    }

    ////Return an array of info (name,value)
    function webskill_check_backup_mods($course,$user_data=false,$backup_unique_code,$instances=null) {
        if (!empty($instances) && is_array($instances) && count($instances)) {
            $info = array();
            foreach ($instances as $id => $instance) {
                $info += webskill_check_backup_mods_instances($instance,$backup_unique_code);
            }
            return $info;
        }

         //First the course data
         $info[0][0] = get_string('modulenameplural','webskill');
         $info[0][1] = count_records('webskill', 'course', '$course');
         return $info;
    }

    ////Return an array of info (name,value)
    function webskill_check_backup_mods_instances($instance,$backup_unique_code) {
         //First the course data
        $info[$instance->id.'0'][0] = '<b>'.$instance->name.'</b>';
        $info[$instance->id.'0'][1] = '';
        return $info;
    }

?>
