<?php  //$Id: upgrade.php,v 1.2 2007/08/08 22:36:54 stronk7 Exp $

/**
 * This file keeps track of upgrades to the webskill module
 * This fragment is called by moodle_needs_upgrading() and /admin/index.php
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

// Sometimes, changes between versions involve
// alterations to database structures and other
// major things that may break installations.
//
// The upgrade function in this file will attempt
// to perform all the necessary actions to upgrade
// your older installtion to the current version.
//
// If there's something it cannot do itself, it
// will tell you what you need to do.
//
// The commands in here will all be database-neutral,
// using the functions defined in lib/ddllib.php

function xmldb_webskill_upgrade($oldversion=0) {

    global $CFG, $THEME, $db;

    $result = true;

    if ($result && $oldversion < 2009083103) {
    
    /// Define field opentoblank to be added to webskill
        $table = new XMLDBTable('webskill');
        $field = new XMLDBField('opentoblank');
        $field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'enddate');
    
    /// Launch add field opentoblank
        $result = $result && add_field($table, $field);
    }
    
    return $result;
}



?>
