<?php // $Id: index.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/**
 * This page lists all the instances of webskill in a particular course
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

/// Replace webskill with the name of your module and remove this line

require_once('../../config.php');
require_once('lib.php');
require_once('locallib.php');

$id = required_param('id', PARAM_INT);   // course

if (! $course = get_record('course', 'id', $id)) {
    error('Course ID is incorrect');
}

require_course_login($course);

add_to_log($course->id, 'webskill', 'view all', "index.php?id=$course->id", '');


/// Get all required stringswebskill

$strwebskills = get_string('modulenameplural', 'webskill');
$strwebskill  = get_string('modulename', 'webskill');


/// Print the header

$navlinks = array();
$navlinks[] = array('name' => $strwebskills, 'link' => '', 'type' => 'activity');
$navigation = build_navigation($navlinks);

print_header_simple($strwebskills, '', $navigation, '', '', true, '', navmenu($course));

/// Get all the appropriate data

if (! $webskills = get_all_instances_in_course('webskill', $course)) {
    notice('There are no instances of webskill', "../../course/view.php?id=$course->id");
    die;
}

/// Print the list of instances (your module will probably extend this)

$timenow  = time();
$strname  = get_string('name');
$strweek  = get_string('week');
$strtopic = get_string('topic');

if ($course->format == 'weeks') {
    $table->head  = array ($strweek, $strname);
    $table->align = array ('center', 'left');
} else if ($course->format == 'topics') {
    $table->head  = array ($strtopic, $strname);
    $table->align = array ('center', 'left', 'left', 'left');
} else {
    $table->head  = array ($strname);
    $table->align = array ('left', 'left', 'left');
}

foreach ($webskills as $webskill) {
    if (!$webskill->visible) {
        //Show dimmed if the mod is hidden
        $link = '<a class="dimmed" href="view.php?id='.$webskill->coursemodule.'">'.format_string($webskill->name).'</a>';
    } else {
        //Show normal if the mod is visible
        $link = '<a href="view.php?id='.$webskill->coursemodule.'">'.format_string($webskill->name).'</a>';
    }

    if ($course->format == 'weeks' or $course->format == 'topics') {
        $table->data[] = array ($webskill->section, $link);
    } else {
        $table->data[] = array ($link);
    }
}

print_heading($strwebskills);
print_table($table);

/// Finish the page

print_footer($course);

?>
