<?php // $Id: lib.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/*
 * Library of functions and constants for module webskill
 * This file should have two well differenced parts:
 *   - All the core Moodle functions, neeeded to allow
 *     the module to work integrated in Moodle.
 *   - All the webskill specific functions, needed
 *     to implement all the module logic. Please, note
 *     that, if the module become complex and this lib
 *     grows a lot, it's HIGHLY recommended to move all
 *     these module specific functions to a new php file,
 *     called "locallib.php" (see forum, quiz...). This will
 *     help to save some memory when Moodle is performing
 *     actions across all modules.
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

define('WEBSKILL_INCLUDE_TEST', 1);
define('WEBSKILL_NEWLINE', "\r\n");
define('WEBSKILL_INDENT', '    ');

//TABS
define('WEBSKILL_NOTAB', 0);
define('WEBSKILL_TAB1', 1);
define('WEBSKILL_TAB2', 2);

//PAGES
// pages of tab 1
// no pages foreseen for first tab

// pages of tab 2
define('WEBSKILL_TAB2_PAGE1', '1');
    define('WEBSKILL_TAB2_PAGE1NAME', 'tab2page1');
define('WEBSKILL_TAB2_PAGE2', '2');
    define('WEBSKILL_TAB2_PAGE2NAME', 'tab2page2');

/**
 * Given an object containing all the necessary data,
 * (defined by the form in mod_form.php) this function
 * will create a new instance and return the id number
 * of the new instance.
 *
 * @param object $webskill An object from the form in mod_form.php
 * @return int The id of the newly inserted webskill record
 */
function webskill_add_instance($webskill) {

    $checkboxes = array('emailconfman', 'opentoblank');
    foreach ($checkboxes as $checkbox) {
        if (empty($webskill->{$checkbox})) {
            $webskill->{$checkbox} = 0;
        }
    }

    $webskill->timecreated = time();

    $xml_answer = webskill_createroom($webskill);
    if (!webskill_readxmlanswer($xml_answer, 'errorcode')) {
        $webskill->roomid = webskill_readxmlanswer($xml_answer, 'roomid');
    }

    if ($webskill->startdate == $webskill->enddate) {
        $webskill->enddate += 3600;
    }
    # May have to add extra stuff in here #

    if ($webskillid = insert_record('webskill', $webskill)) {
        if (!empty($webskill->roomid)) {
            if ($webskill->emailconfman && $webskill->startdate < time()) {
                webskill_sendemail($webskill, 'add');
            }
        }
    }
    return $webskillid;
}


/**
 * Given an object containing all the necessary data,
 * (defined by the form in mod_form.php) this function
 * will update an existing instance with new data.
 *
 * @param object $webskill An object from the form in mod_form.php
 * @return boolean Success/Fail
 */
function webskill_update_instance($webskill) {

    // print_object($webskill);
    $checkboxes = array('emailconfman', 'opentoblank');
    foreach ($checkboxes as $checkbox) {
        if (empty($webskill->{$checkbox})) {
            $webskill->{$checkbox} = 0;
        }
    }

    # May have to add extra stuff in here #
    if ($webskill->startdate == $webskill->enddate) {
        $webskill->enddate += 3600;
    }

    $webskill->timemodified = time();
    $webskill->id = $webskill->instance;

    $oldwebskill = get_record('webskill', 'id', $webskill->id);

    // attento, $webskill è il record che ho composto adesso in mod_form.php
    // QUINDI è SEMPRE empty($webskill->roomid)
    if (empty($oldwebskill->roomid)) {
        $xml_answer = webskill_createroom($webskill);
        if (!webskill_readxmlanswer($xml_answer, 'errorcode')) {
            $webskill->roomid = webskill_readxmlanswer($xml_answer, 'roomid');
        }
    } else {
        $webskill->roomid = $oldwebskill->roomid;
        $xml_answer = webskill_modifyroom($webskill);
        if (webskill_readxmlanswer($xml_answer, 'errorcode')) {
            return false;
        } // else procedi regolamente
    }

    if ($webskillid = update_record('webskill', $webskill)) {
        if (!empty($webskill->roomid)) {
            // startdate
            $oldstartdate = $oldwebskill->startdate;
            $newstartdate = $webskill->startdate;

            // confmanid
            $oldconfman = $oldwebskill->confmanid;
            $newconfman = $webskill->confmanid;

            // emailconfman
            $oldemailconfman = $oldwebskill->emailconfman;
            $newemailconfman = empty($webskill->emailconfman) ? 0 : 1;

            if ($oldconfman != $newconfman) { // se hai cambiato il conference manager
                if ($oldemailconfman) { // e se avevi avvertito il precedente
                    // disdici l'incarico al precedente conference manager
                    if ($oldstartdate > time()) {
                        // solo se non lo ha ancora svolto
                        webskill_sendemail($webskill, 'retire');
                    }
                }
                if ($newemailconfman) { // e se è richiesta l'email al nuovo conference manager
                    // incarica il nuovo conference manager
                    if ($newstartdate > time()) {
                        // solo se la data di inizio conferenza è nel futuro
                        webskill_sendemail($webskill, 'add');
                    }
                }
            } else {
                // il conference manager è lo stesso, avvertilo del cambiamento di programma
                if ($newemailconfman) {
                    if ($oldemailconfman) {  // se gliela avevi già mandata prima
                        if ($oldstartdate != $newstartdate) {  // se l'orario è cambiato
							if ($newstartdate > time()) {
								if ($oldstartdate <= time()) {
									// se aveva già operato, dagli un nuovo incarico
									// (sto aggiornando l'istanza fra la fine della videoconferenza e il passaggio del cron)
									webskill_sendemail($webskill, 'add');
								} else {
									// se non aveva ancora operato, aggiorna il precedente incarico
									webskill_sendemail($webskill, 'update');
								}
							} else {
							    // se la nuova startdate è nel passato mai nessuno aprirà questa webconf
                                webskill_sendemail($webskill, 'del');
							}
                        }
                    } else {
						if ($newstartdate > time()) {
                            // se non gliela avevi già mandata prima, avertilo
                            webskill_sendemail($webskill, 'add');
                        }
                    }
                }
            }
        }
    }
    return $webskillid;
}


/**
 * Given an ID of an instance of this module,
 * this function will permanently delete the instance
 * and any data that depends on it.
 *
 * @param int $id Id of the module instance
 * @return boolean Success/Failure
 */
function webskill_delete_instance($id) {

    if (! $webskill = get_record('webskill', 'id', $id)) {
        return false;
    }

    $result = true;

    # Delete any dependent records here #
    // room for an instance is supposed to be never more than one
    $xml_answer = webskill_deleteroom($webskill);
    if ($webskill->emailconfman && ($webskill->startdate > time())) {
        // se il conference manager era stato avvertito, disdici l'incarico
        webskill_sendemail($webskill, 'del');
    }

    if (! delete_records('webskill', 'id', $webskill->id)) {
        $result = false;
    }

    return $result;
}


/**
 * Return a small object with summary information about what a
 * user has done with a given particular instance of this module
 * Used for user activity reports.
 * $return->time = the time they did it
 * $return->info = a short text description
 *
 * @return null
 * @todo Finish documenting this function
 */
function webskill_user_outline($course, $user, $mod, $webskill) {
    return $return;
}


/**
 * Print a detailed representation of what a user has done with
 * a given particular instance of this module, for user activity reports.
 *
 * @return boolean
 * @todo Finish documenting this function
 */
function webskill_user_complete($course, $user, $mod, $webskill) {
    return true;
}


/**
 * Given a course and a time, this module should find recent activity
 * that has occurred in webskill activities and print it out.
 * Return true if there was output, or false is there was none.
 *
 * @return boolean
 * @todo Finish documenting this function
 */
function webskill_print_recent_activity($course, $isteacher, $timestart) {
    return false;  //  True if anything was printed, otherwise false
}


/**
 * Function to be run periodically according to the moodle cron
 * This function searches for things that need to be done, such
 * as sending out mail, toggling flags etc ...
 *
 * @return boolean
 * @todo Finish documenting this function
 **/
function webskill_cron() {
    return true;
}

/**
 * Must return an array of user records (all data) who are participants
 * for a given instance of webskill. Must include every user involved
 * in the instance, independient of his role (student, teacher, admin...)
 * See other modules as example.
 *
 * @param int $webskillid ID of an instance of this module
 * @return mixed boolean/array of students
 */
function webskill_get_participants($webskillid) {
    return false;
}


/**
 * This function returns if a scale is being used by one webskill
 * if it has support for grading and scales. Commented code should be
 * modified if necessary. See forum, glossary or journal modules
 * as reference.
 *
 * @param int $webskillid ID of an instance of this module
 * @return mixed
 * @todo Finish documenting this function
 */
function webskill_scale_used($webskillid, $scaleid) {
    $return = false;

    //$rec = get_record("webskill","id","$webskillid","scale","-$scaleid");
    //
    //if (!empty($rec) && !empty($scaleid)) {
    //    $return = true;
    //}

    return $return;
}


/**
 * Checks if scale is being used by any instance of webskill.
 * This function was added in 1.9
 *
 * This is used to find out if scale used anywhere
 * @param $scaleid int
 * @return boolean True if the scale is used by any webskill
 */
function webskill_scale_used_anywhere($scaleid) {
    if ($scaleid and record_exists('webskill', 'grade', -$scaleid)) {
        return true;
    } else {
        return false;
    }
}


/**
 * Execute post-install custom actions for the module
 * This function was added in 1.9
 *
 * @return boolean true if success, false on error
 */
function webskill_install() {
    return true;
}


/**
 * Execute post-uninstall custom actions for the module
 * This function was added in 1.9
 *
 * @return boolean true if success, false on error
 */
function webskill_uninstall() {
    return true;
}


//////////////////////////////////////////////////////////////////////////////////////
/// Any other webskill functions go here.  Each of them must have a name that
/// starts with webskill_
/// Remember (see note in first lines) that, if this section grows, it's HIGHLY
/// recommended to move all funcions below to a new "localib.php" file.

    function webskill_createroom($webskill) {
        global $CFG;

        // attenzione:
        // la chiamata a questa funzione viene fatta anche in fase di webskill_add_instance
        // nell'ambito della quale il record $webskill ancora non esiste
        // quindi non posso usare
        //     global $webskill;
        // ma lo devo passare come parametro
        $xml_answer = webskill_isroomavailable($webskill);
        if (webskill_readxmlanswer($xml_answer, 'errorcode')) {
            // The room is not available, return the message
            return $xml_answer;
        } else {
            // The room is available, try to create it
            $xml_request = teleskill_beginrequest('1');

            $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
            $xml_request .= WEBSKILL_INDENT.'<startdate>'.gmdate("Y-m-d H:i:s", $webskill->startdate).'</startdate>'.WEBSKILL_NEWLINE;
            $xml_request .= WEBSKILL_INDENT.'<enddate>'.gmdate("Y-m-d H:i:s", $webskill->enddate).'</enddate>'.WEBSKILL_NEWLINE;
            $xml_request .= WEBSKILL_INDENT.'<title>'.$webskill->title.'</title>'.WEBSKILL_NEWLINE;
            if ($webskill->descr)
                $xml_request .= WEBSKILL_INDENT.'<descr>'.$webskill->descr.'</descr>'.WEBSKILL_NEWLINE;
            $xml_request .= WEBSKILL_INDENT.'<users>'.$webskill->users.'</users>'.WEBSKILL_NEWLINE;

            // if (($webskill->logo != $CFG->resource_defaulturl) || ($webskill->skin != $CFG->resource_defaulturl)) {
            if (! (empty($webskill->logo) && empty($webskill->skin)) ) {
                $serverhost_parsed = parse_url($CFG->webskill_serverhost);
                if (!empty($webskill->logo)) {
                    $logohost_parsed = parse_url($webskill->logo);
                    if (isset($logohost_parsed['host'])) {
                        $absolute = ($serverhost_parsed['host'] == $logohost_parsed['host']) ? 0 : 1;
                    } else {
                        $absolute = 1;
                    }
                    $xml_request .= WEBSKILL_INDENT.'<logo absolute="'.$absolute.'">'.$webskill->logo.'</logo>'.WEBSKILL_NEWLINE;
                }

                if (!empty($webskill->skin)) {
                    $skinhost_parsed = parse_url($webskill->skin);
                    if (isset($skinhost_parsed['host'])) {
                        $absolute = ($skinhost_parsed['host'] == $skinhost_parsed['host']) ? 0 : 1;
                    } else {
                        $absolute = 1;
                    }
                    $absolute = ($serverhost_parsed['host'] == $skinhost_parsed['host']) ? 0 : 1;
                    $xml_request .= WEBSKILL_INDENT.'<skin absolute="'.$absolute.'">'.$webskill->skin.'</skin>'.WEBSKILL_NEWLINE;
                }
            }
            $xml_request .= '</ews>';

            // qui restituisco la xml_answer che deve essere analizzata dal ricevente
            $xml_answer = webskill_getanswerfrom($xml_request);
            if (!webskill_readxmlanswer($xml_answer, 'errorcode')) {
                $webskill->roomid = webskill_readxmlanswer($xml_answer, 'roomid');
            }
            return $xml_answer;
        }
    }

    function webskill_readxmlanswer($xml_answer, $tag) {
        global $CFG;

        if (empty($xml_answer)) {
            if ($CFG->debug < DEBUG_ALL) {
                $a = get_string('debugall', 'admin');
                $a = get_string('riseupdebuglevel', 'webskill', $a);
            } else {
                $a = '';
            }
            return get_string('emptyxml','webskill', $a);
        }

        $regexp = "|<$tag>(.*)</$tag>|";
        if (preg_match($regexp, $xml_answer, $matches)) {
            return $matches[1]; //it is a single value
        }
    }

    function webskill_sendemail($webskill,$action) {
        global $CFG, $USER, $COURSE;

        $a->courseurl = $CFG->wwwroot.'/course/view.php?id='.$COURSE->id;
        $a->coursenname = $COURSE->fullname;
        $a->conferencename = $webskill->name;
        $a->timestart = userdate($webskill->startdate);

        $htmlbody = get_string('emailbody_'.$action,'webskill',$a);
        $textbody = strip_tags($htmlbody);
        //echo $emailbody;
        //die;
        $recipient = get_record('user', 'id', $webskill->confmanid, null, null, null, null, 'firstname, lastname, email, mailformat, maildisplay');
        $from      = get_record('user', 'id', $USER->id, null, null, null, null, 'firstname, lastname, email, mailformat, maildisplay');
        if(!email_to_user($recipient, $from, get_string('emailsubject','webskill', $a), $textbody, $htmlbody)) {
            $a = new object;
            $a->roomcreator = fullname($from);
            $a->conferencemanager = fullname($recipient);
            print_string('emailnotsent','webskill', $a);
        }
    }

    function webskill_modifyroom($webskill) {
        global $CFG;

        $xml_request = teleskill_beginrequest('6');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<roomid>'.$webskill->roomid.'</roomid>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<startdate>'.gmdate("Y-m-d H:i:s", $webskill->startdate).'</startdate>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<enddate>'.gmdate("Y-m-d H:i:s", $webskill->enddate).'</enddate>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<title>'.$webskill->title.'</title>'.WEBSKILL_NEWLINE;
        if ($webskill->descr)
            $xml_request .= WEBSKILL_INDENT.'<descr>'.$webskill->descr.'</descr>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<users>'.$webskill->users.'</users>'.WEBSKILL_NEWLINE;

        if (! (empty($webskill->logo) && empty($webskill->skin)) ) {
            $serverhost_parsed = parse_url($CFG->webskill_serverhost);

            if (!empty($webskill->logo)) {
                $logohost_parsed = parse_url($webskill->logo);
                $absolute = ($serverhost_parsed['host'] == $logohost_parsed['host']) ? 0 : 1;
                $xml_request .= WEBSKILL_INDENT.'<logo absolute="'.$absolute.'">'.$webskill->logo.'</logo>'.WEBSKILL_NEWLINE;
            }

            if (!empty($webskill->skin)) {
                $skinhost_parsed = parse_url($webskill->skin);
                $absolute = ($serverhost_parsed['host'] == $skinhost_parsed['host']) ? 0 : 1;
                $xml_request .= WEBSKILL_INDENT.'<skin absolute="'.$absolute.'">'.$webskill->skin.'</skin>'.WEBSKILL_NEWLINE;
            }
        }
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_deleteroom($webskill) {
        global $CFG;

        // attenzione:
        // la chiamata a questa funzione viene fatta anche in fase di delete_instance
        // nell'ambito della quale il record $webskill non è definito
        // quindi non posso usare
        //     global $webskill;
        // ma lo devo passare come parametro

        $xml_request = teleskill_beginrequest('2');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<roomid>'.$webskill->roomid.'</roomid>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_isroomavailable($webskill) {
        global $CFG;

        // attenzione:
        // la chiamata a questa funzione viene fatta anche in fase di create_instance
        // nell'ambito della quale il record $webskill ancora non esiste
        // quindi non posso usare
        //     global $webskill;
        // ma lo devo passare come parametro

        $xml_request = teleskill_beginrequest('5');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<startdate>'.gmdate("Y-m-d H:i:s", $webskill->startdate).'</startdate>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<enddate>'.gmdate("Y-m-d H:i:s", $webskill->enddate).'</enddate>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<users>'.$webskill->users.'</users>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function teleskill_beginrequest($type) {
        $xml_request = '<?xml version="1.0" encoding="UTF-8"?>'.WEBSKILL_NEWLINE;
        $xml_lang = (current_language() == 'it_utf8') ? 'IT' : 'EN';
        $xml_request .= '<ews type="'.$type.'" lang="'.$xml_lang.'">'.WEBSKILL_NEWLINE;
        return $xml_request;
    }

    /*function webskill_curl_getanswerfrom($xml_request) {
        // questa funzione usa cURL per acquisire la risposta del server
        // sfortunatamente il cURL non funziona se il server si trova dietro un proxy

        // per far funzionare il cURL con un proxt è necessario aggiungere le seguenti tre opzioni:
        // curl_setopt($ch, CURLOPT_PROXY, “http://000.000.000.000:0000″);
        // curl_setopt($ch, CURLOPT_PROXYPORT, 0000);
        // curl_setopt ($ch, CURLOPT_PROXYUSERPWD, “xxx:xxx”);

        global $CFG;

        $ch = curl_init();
        //echo '$CFG->webskill_serverhost = '.$CFG->webskill_serverhost.'<br />';
        $url = $CFG->webskill_serverhost;
        if ($CFG->webskill_serverport != '80')
            $url .= ':'.$CFG->webskill_serverport;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        //curl_setopt($ch, CURLOPT_HEADER, 1); // never uncomment me

        curl_setopt($ch, CURLOPT_POSTFIELDS, 'message='.urlencode($xml_request));

        $xml_answer = curl_exec($ch);

        if (($CFG->debug >= DEBUG_ALL) && $CFG->debugdisplay) {
            if (!$xml_answer) {
                $output = 'No cURL data returned for '.$url.'<br />';
                if (curl_error($ch))
                    $output .= curl_error($ch).'<br />';
                $info = curl_getinfo($ch);
                if ($info['http_code'] != 200)
                    $output .= 'Last received HTTP code: '.$info['http_code'].'<br />';
                echo $output;
            }
        }

        curl_close($ch);

        if (($CFG->debug >= DEBUG_ALL) && $CFG->debugdisplay) {
            echo '$xml_request = <textarea cols="90" rows="10">'.$xml_request.'</textarea><br />';

            echo '$xml_answer = <textarea cols="90" rows="10">'.$xml_answer.'</textarea><br />';
            print_string('reducedebuglevel','webskill');
        }
        return $xml_answer;
    }*/

    function webskill_getanswerfrom($xml_request) {
        /* invece di usare la funzione file_get_contents() che invia i dati con una GET,
        reinvento questa funzione che è analoga a file_get_contents() ma invia i dati in POST */
        global $CFG;
        $xml_answer = false;

        $url = parse_url($CFG->webskill_serverhost);
        $url['protocol']=$url['scheme'].'://';



        $post_data = 'message='.urlencode($xml_request);

        $post_request = 'POST '.$CFG->webskill_serverhost.' HTTP/1.0'.WEBSKILL_NEWLINE
            .'Host: '.$url['host'].WEBSKILL_NEWLINE
            .'User-Agent: PHP Script'.WEBSKILL_NEWLINE
            .'Content-type: application/x-www-form-urlencoded'.WEBSKILL_NEWLINE
            .'Content-length: '.strlen($post_data).WEBSKILL_NEWLINE
			.'Connection: close'.WEBSKILL_NEWLINE.WEBSKILL_NEWLINE
            .$post_data.WEBSKILL_NEWLINE.WEBSKILL_NEWLINE;

        $socket = fsockopen($url['host'], $CFG->webskill_serverport, $errno, $errstr, 30);

        if ($socket) {
            $xml_answer = '';
			socket_set_timeout($socket, 10);
			fputs($socket, $post_request);

			// discad header
			$head = fgets($socket);
			if(substr_count($head, "200 OK") > 0) {
				$hedaer_row = 0;
				while (!(fgets($socket) == WEBSKILL_NEWLINE) && $hedaer_row < 100) {
				    ++$hedaer_row;
				}
				if($hedaer_row == 100)
				    return false;
			} else {
			    return false;
			}


			while (!feof($socket)) {
			    $xml_answer .= fgets($socket, 4096);
			}
			fclose($socket);
			if (($CFG->debug >= DEBUG_ALL) && $CFG->debugdisplay) {
				echo '$xml_request = <textarea cols="90" rows="10">'.$xml_request.'</textarea><br />';

				echo '$xml_answer = <textarea cols="90" rows="10">'.$xml_answer.'</textarea><br />';
				print_string('reducedebuglevel','webskill');
			}
        }
        // print_object($xml_answer);
        return $xml_answer;
    }

?>
