<?php // $Id: locallib.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/*
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

    require_once("$CFG->dirroot/mod/webskill/lib.php");

    function webskill_user_candoanything() {
        $context = get_context_instance(CONTEXT_SYSTEM);

        return (has_capability('moodle/site:doanything', $context));
    }

    function webskill_useris_conferencemanagercandidate($cm) {
        $context = get_context_instance(CONTEXT_MODULE, $cm->id);

        //return (has_capability('mod/webskill:conferencemanagercandidate', $context, NULL, false));
        return (has_capability('mod/webskill:conferencemanagercandidate', $context));
    }

    function webskill_usercan_managelogs($cm) {
        $context = get_context_instance(CONTEXT_MODULE, $cm->id);

        //return (has_capability('mod/webskill:managelogs', $context, NULL, false));
        return (has_capability('mod/webskill:managelogs', $context));
    }

    /**
     * The only purpose of this function is to send the message to the server, read the server answer,
     * discard the header and return the other content
     *
     * @param     string    $xml_request     is the xml request that will be sended to teleskill
     *
     * @return     mixed     the xml returned by teleskill or false if error
     */
    function webskill_enableuser($webskill) {
        global $CFG, $USER;
        $role = ($webskill->confmanid == $USER->id) ? '2' : '1';
        $lang = ($USER->lang == 'it_utf8') ? 'IT' : 'EN';
       
        $xml_request = teleskill_beginrequest('3');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<roomid>'.$webskill->roomid.'</roomid>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<lmsuserid>'.$USER->id.'</lmsuserid>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<role>'.$role.'</role>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<name>'.fullname($USER).'</name>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<lang>'.$lang.'</lang>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<email>'.$USER->email.'</email>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_askforlogs($complete, $webskill) {
        global $CFG;

        $xml_request = teleskill_beginrequest('10');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<roomid>'.$webskill->roomid.'</roomid>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<complete>'.$complete.'</complete>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_channeldatarequest() {
        global $CFG;

        $xml_request = teleskill_beginrequest('11');

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_sessions($roomid,$fromdate,$todate) {
        global $CFG;

        if (empty($roomid)) {
            $xml_request = teleskill_beginrequest('21');
        } else {
            $xml_request = teleskill_beginrequest('20');
        }

        $xml_request .= WEBSKILL_INDENT.'<clientcode>'.$CFG->webskill_clientcode.'</clientcode>'.WEBSKILL_NEWLINE;
        if (!empty($roomid))
            $xml_request .= WEBSKILL_INDENT.'<roomid>'.$roomid.'</roomid>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<fromdate>'.$fromdate.'</fromdate>'.WEBSKILL_NEWLINE;
        $xml_request .= WEBSKILL_INDENT.'<todate>'.$todate.'</todate>'.WEBSKILL_NEWLINE;
        $xml_request .= '</ews>';

        return webskill_getanswerfrom($xml_request);
    }

    function webskill_displaylogs($xml_answer) {
//print_object($xml_answer);
        $xml_structure = simplexml_load_string($xml_answer);
//print_object($xml_structure);
        if ($xml_structure->session) {
            foreach ($xml_structure->session as $thissession) {
                $sid = webskill_parsexml('sid',$thissession);
                $uid = webskill_parsexml('uid',$thissession);
                $role = webskill_parsexml('role',$thissession);
                $date = webskill_parsexml('date',$thissession);
                $duration = webskill_parsexml('duration',$thissession);
                switch ($role) {
                case '1':
                    $role_string = get_string('participant','webskill');
                    break;
                case '2':
                    $role_string = get_string('conferencemanager','webskill');
                    break;
                case '3':
                    $role_string = get_string('speaker','webskill');
                    break;
                default:
                    echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                    echo 'I have $role = '.$role.'<br />';
                    echo 'But the right "case" is missing<br />';
                }
                $table->data[] = array($sid, $uid, $role_string, $date, $duration);
            }

            $table->tablealign = 'center';
            $table->head = array(get_string('header_sid','webskill'),
                                 get_string('header_uid','webskill'),
                                 get_string('header_role','webskill'),
                                 get_string('header_date','webskill'),
                                 get_string('header_duration','webskill'));
            $table->align = array('left','left','left','left','left');
            $table->wrap = array(false,false,false,false,false);
            $table->size = array('20%','20%','20%','20%','20%');

            print_table($table, false);
        } else {
            print_container_start(true, 'box generalbox boxaligncenter boxwidthnormal');
            print_string('nologsavailable', 'webskill');
            print_container_end();
        }
    }

    function webskill_displaychanneldata($xml_answer) {
        $credits = webskill_readxmlanswer($xml_answer, 'credits');
        $users = webskill_readxmlanswer($xml_answer, 'users');
        $rooms = webskill_readxmlanswer($xml_answer, 'rooms');

        $str_credits = ($credits) ? get_string('credits', 'webskill', $credits) : get_string('flatchannel', 'webskill');
        $str_users   = ($users)   ? $users                                      : get_string('unlimited', 'webskill');
        $str_rooms   = $rooms     ? get_string('rooms', 'webskill', $rooms)     : get_string('unlimitedrooms', 'webskill');

        $table->tablealign = 'center';
        $table->head = array(get_string('header_credits','webskill'),
                             get_string('header_users','webskill'),
                             get_string('header_rooms','webskill'));
        $table->data[] = array($str_credits, $str_users, $str_rooms);
        $table->align = array('left','left','left');
        $table->wrap = array(false,false,false);
        $table->size = array('33%','33%','34%');

        print_table($table, false);
        print_string('channelloginfo', 'webskill');
    }

    function webskill_displaysession($xml_answer) {
    $debug = false;
    if ($debug) {
        $xml_answer = '<?xml version="1.0" encoding="UTF-8"?>

<ews>
    <errorcode>errorcode_content</errorcode>
    <errormessage>errormessage_content</errormessage>
    <recs>
         <rec id="98" roomid="44" status="1" date="2008-11-24 14:00:00" duration="900">
             <file type="1" mode="1" src="ftp://www.mysite.com/example.flv" />
             <file type="2" mode="1" src="ftp://www.mysite.com/example.avi" />
         </rec>
         <rec id="99" roomid="66" status="1" date="2008-11-25 10:00:00" duration="650">
             <file type="1" mode="3" src="rtmp://www.mysite.com/example.flv" />
         </rec>
         <rec id="100" roomid="88" status="2" date="2008-11-26 10:00:00" duration="1845" />
    </recs>
</ews>';
        }
        $xml_structure = simplexml_load_string($xml_answer);
        //print_object($xml_structure);
        if (!count($xml_structure->recs->rec)) {
            print_container_start(true, 'box generalbox boxaligncenter boxwidthnormal');
            print_string('nosessionperroomavailable', 'webskill');
            print_container_end();
            return;
        }

        foreach($xml_structure->recs->rec as $rec) {
            $description = '<strong>'.get_string('recorddescription','webskill').'</strong>';
            $description .= '<blockquote><div>';
            foreach($rec->attributes() as $attribute => $value) {
                $description .= get_string('sess_'.$attribute,'webskill').' = ';
                if ($attribute == 'status') {
                    switch ($value) {
                    case '1':
                        $description .= get_string('recavailable','webskill');
                        break;
                    case '2':
                        $description .= get_string('recnotavailable','webskill');
                        break;
                    default:
                        echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                        echo 'I have $rvalueole = '.$value.'<br />';
                        echo 'But the right "case" is missing<br />';
                    }
                } else {
                    $description .= $value;
                }
                $description .= '<br />';
            }
            $description .= '<ul>';
            if (count($rec->file)) {
                foreach($rec->file as $thisfile) {
                    //print_object($thisfile);
                    $description .= '<li>';
                    $description .= get_string('filedescription','webskill');
                    $description .= '<ul>';
                    foreach($thisfile->attributes() as $attribute => $value) {
                        $description .= '<li>'.get_string('sess_'.$attribute,'webskill').' = ';
                        switch ($attribute) {
                        case 'type':
                            switch ($value) {
                            case '1':
                                $description .= get_string('flv','webskill');
                                break;
                            case '2':
                                $description .= get_string('avi','webskill');
                                break;
                            default:
                                echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                                echo 'I have $rvalueole = '.$value.'<br />';
                                echo 'But the right "case" is missing<br />';
                            }
                            break;
                        case 'mode':
                            switch ($value) {
                            case '1':
                                $description .= get_string('ftp','webskill');
                                break;
                            case '2':
                                $description .= get_string('http','webskill');
                                break;
                            case '3':
                                $description .= get_string('streaming','webskill');
                                break;
                            default:
                                echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                                echo 'I have $rvalueole = '.$value.'<br />';
                                echo 'But the right "case" is missing<br />';
                            }
                            break;
                        case 'src':
                            $description .= '<a href="'.$value.'" title="'.get_string('sess_src','webskill').'" >'.$value.'</a>';
                            break;
                        default:
                            echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                            echo 'I have $attribute = '.$attribute.'<br />';
                            echo 'But the right "case" is missing<br />';
                        }
                        $description .= '</li>';
                    }
                    $description .= '</ul>';
                    $description .= '</li>';
                }
            } else {
                $description .= '<li>'.get_string('nodescriptionfilefound','webskill').'</li>';
            }
            $description .= '</ul></div></blockquote>';
            echo $description;
        }
    }

    function webskill_parsexml($xml_tag,$session) {
        $regexp = "|$xml_tag=\"(.*)\"|U";
        if (preg_match($regexp, $session, $field)) {
            return $field[1]; //it is a single value
        } else {
            return ''; //it is a single value
        }
    }

    function webskill_redo_button($returnurl) {
        ?>
        <!-- <form style="text-align:center; margin:7px;" method="post" action="<?php echo $returnurl ?>"> -->
        <form id="notice" method="post" action="<?php echo $returnurl ?>">
        <div style="text-align:center;">
            <input name="goto" id="goto" type="submit" value="<?php echo get_string('redo_log','webskill'); ?>" title="<?php print_string('redo_log','telethon'); ?>" />
        </div>
        </form>
        <?php
    }

?>