<?php // $Id: join.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/**
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

    require_once('../../../config.php');
    require_once('../locallib.php');

    $session = required_param('s', PARAM_ALPHANUM); // sessionid
    $id      = required_param('id', PARAM_INT);              // course_module ID, or

    if ($id) {
        if (! $cm = get_coursemodule_from_id('webskill', $id)) {
            error('Course Module ID was incorrect');
        }

        if (! $course = get_record('course', 'id', $cm->course)) {
            error('Course is misconfigured');
        }

        if (! $webskill = get_record('webskill', 'id', $cm->instance)) {
            error('Course module is incorrect');
        }

    } else {
        error('You must specify a course_module ID or an instance ID');
    }

//print_object($cm);
//print_object($course);
//print_object($webskill);

    require_login($course, true, $cm);

    $xml_answer = webskill_enableuser($webskill);
    if (webskill_readxmlanswer($xml_answer, 'errorcode')) {
        /// Print the page header
        $strwebskills = get_string('modulenameplural', 'webskill');
        $strwebskill  = get_string('modulename', 'webskill');
    
        $navlinks = array();
        $navlinks[] = array('name' => $strwebskills, 'link' => "index.php?id=$course->id", 'type' => 'activity');
        $navlinks[] = array('name' => format_string($webskill->name), 'link' => '', 'type' => 'activityinstance');
    
        $navigation = build_navigation($navlinks);
    
        print_header_simple(format_string($webskill->name), '', $navigation, '', '', true,
                      update_module_button($cm->id, $course->id, $strwebskill), navmenu($course, $cm));
    
        /// Print the main part of the page
        print_container_start(true, 'box generalbox boxaligncenter boxwidthnormal');
        $a = webskill_readxmlanswer($xml_answer, 'errormessage');
        print_string('notjoined', 'webskill', $a);
        print_container_end();
    } else {
        $url = webskill_readxmlanswer($xml_answer, 'url');
        add_to_log($course->id, "webskill", "join", "$url", "$webskill->id");
        redirect($url, null, 0);
    }
    /// Finish the page
    print_footer($course);

?>