<?php // $Id: mod_form.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/**
 * This file defines the main webskill configuration form
 * It uses the standard core Moodle (>1.8) formslib. For
 * more info about them, please visit:
 *
 * http://docs.moodle.org/en/Development:lib/formslib.php
 *
 * The form must provide support for, at least these fields:
 *   - name: text element of 64cc max
 *
 * Also, it's usual to use these fields:
 *   - intro: one htmlarea element to describe the activity
 *            (will be showed in the list of activities of
 *             webskill type (index.php) and in the header
 *             of the webskill main page (view.php).
 *   - introformat: The format used to write the contents
 *             of the intro field. It automatically defaults
 *             to HTML when the htmleditor is used and can be
 *             manually selected if the htmleditor is not used
 *             (standard formats are: MOODLE, HTML, PLAIN, MARKDOWN)
 *             See lib/weblib.php Constants and the format_text()
 *             function for more info
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

require_once($CFG->dirroot.'/course/moodleform_mod.php');

class mod_webskill_mod_form extends moodleform_mod {

    function definition() {
        global $COURSE, $CFG;

        $mform =& $this->_form;

//-------------------------------------------------------------------------------
    /// Adding the "general" fieldset, where all the common settings are showed
        $mform->addElement('header', 'general', get_string('general', 'form'));

    /// Adding the standard "name" field
        $mform->addElement('text', 'name', get_string('webskillname', 'webskill'), array('size'=>'64'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');

    /// Adding the required "intro" field to hold the description of the instance
        $mform->addElement('htmleditor', 'intro', get_string('webskillintro', 'webskill'));
        $mform->setType('intro', PARAM_RAW);
        $mform->addRule('intro', get_string('required'), 'required', null, 'client');
        $mform->setHelpButton('intro', array('writing', 'richtext'), false, 'editorhelpbutton');

    /// Adding "introformat" field
        $mform->addElement('format', 'introformat', get_string('format'));

    ////////////////////////////////////////////////////////////////////////////////////////////////
    /// Opening the "webskill" fieldset
        $mform->addElement('header', 'webskill_specific_fs', get_string('webskillspecific', 'webskill'));

    //  ID del conferencemanager, ovvero di colui che è abilitato all'apertura della stanza che si sta creando adesso.
    /// "conferencemanager" field
    // ugly workaround until I can't find the proper way o code it (probably in to forum php code)
    // I want the list of users with the 'mod/webskill:conferencemanagercandidate' capability assigned ONLY in the context of this course
    if ($context = get_context_instance(CONTEXT_COURSE, $COURSE->id)) {
        $use_inherited_capability = false;
        if ($use_inherited_capability) {
            $users = get_users_by_capability($context, 'mod/webskill:conferencemanagercandidate','id,firstname,lastname','lastname');
            unset($temp);
            foreach ($users as $thisuser) {
                $temp[$thisuser->id] = fullname($thisuser);
            }
        } else {
            // $courseroles = get_roles_with_assignment_on_context($context);
            $courseroles = get_roles_with_capability('mod/webskill:conferencemanagercandidate', CAP_ALLOW, $context);
            //print_object($courseroles);
            $conferencemanagers = array();
            foreach ($courseroles as $thisrole) {
                if ($roleusers = get_role_users($thisrole->id, $context, false, 'u.id, u.firstname, u.lastname')) {
                    // questo è l'elenco degli iscritti direttamente al corso
                    $conferencemanagers = array_merge($conferencemanagers, $roleusers);
                }
            }
            //print_object($conferencemanagers);

            unset($temp);
            foreach ($conferencemanagers as $k => $v) {
                $temp[$v->id] = fullname($v);
            }
            if (isset($temp)) {
                asort($temp);
            }
        }
        if (isset($temp)) {
            $mform->addElement('select', 'confmanid', get_string('conferencemanager','webskill'), $temp, null);
        } else {
            $mform->addElement('static', 'warning', get_string('conferencemanager','webskill'), get_string('missingconferencemanager', 'webskill'));
        }
    } else {
        die('badcontext at the row '.__LINE__.' of the file '.__FILE__.'<br />');
    }

    //  manda una email al conference manager per informarlo dell'incarico ricevuto.
    /// "emailconferencemanager" field
        $mform->addElement('checkbox', 'emailconfman', get_string('emailconfman', 'webskill'));
        $mform->setDefault('emailconfman', '1');

    //  Data e ora di inizio della videoconferenza.
    //  La data e l'ora dovranno essere nel formato: yyyy-mm-dd hh:mm:ss impostate a GMT+0.
    /// "startdate" field
        $mform->addElement('date_time_selector', 'startdate', get_string('startdate', 'webskill'));

    //  Data e ora di fine della videoconferenza.
    //  La data e l'ora dovranno essere nel formato: yyyy-mm-dd hh:mm:ss impostate a GMT+0.
    /// "enddate" field
        $mform->addElement('date_time_selector', 'enddate', get_string('enddate', 'webskill'));

    //  accedi alla videoconferenza in una uova finestra?
    /// "opentoblank" field
        $mform->addElement('checkbox', 'opentoblank', get_string('opentoblank', 'webskill'));
        $mform->setDefault('opentoblank', '1');

    //  Stringa alfanumerica (max 50 caratteri) contenente il titolo della stanza.
    /// "title" field
        $mform->addElement('text', 'title', get_string('title','webskill'));
        $mform->setType('title', PARAM_TEXT);
        $mform->addRule('title', get_string('required'), 'required', null, 'client');

    //  Stringa alfanumerica (max 2000 caratteri) contenente la descrizione della stanza.
    /// "descr" field
        $mform->addElement('htmleditor', 'descr', get_string('descr', 'webskill'));
        $mform->setType('descr', PARAM_RAW);
        $mform->addRule('descr', get_string('required'), 'required', null, 'client');

    //  Dimensiona la stanza per un numero di partecipanti massimo.
    /// "users" field
        unset($temp);
        $temp['2'] = '2';
        $temp['3'] = '3';
        $temp['4'] = '4';
        $temp['5'] = '5';
        $temp['10'] = '10';
        $temp['15'] = '15';
        $temp['20'] = '20';
        $temp['35'] = '35';
        $temp['50'] = '50';
        $temp['75'] = '75';
        $temp['100'] = '100';
        $mform->addElement('select', 'users', get_string('users','webskill'), $temp, null);

    //  Stringa alfanumerica (max 255 caratteri) contenente la "URL" dell’immagine di benvenuto da visualizzare nell’applicativo di videoconferenza.
    //  L’attributo "absolute" deve essere impostato a "1" se il file si trova su di un server esterno o a "0" se è invece presente sul server di videoconferenza.
    /// "logo" field
        $mform->addElement('choosecoursefile', 'logo', get_string('logo','webskill'), null, array('maxlength' => 255, 'size' => 48));
        //$mform->setDefault('logo', $CFG->resource_defaulturl);
        $mform->addGroupRule('logo', array('value' => array(array(get_string('maximumchars', '', 255), 'maxlength', 255, 'client'))));

        $logobutton = $mform->addElement('button', 'logobutton', get_string('searchweb', 'resource').'...');
        $buttonattributes = array('title'=>get_string('searchweb', 'resource'), 'onclick'=>"return window.open('"
                          . "$CFG->resource_websearch', 'websearch', 'menubar=1,location=1,directories=1,toolbar=1,"
                          . "scrollbars,resizable,width=800,height=600');");
        $logobutton->updateAttributes($buttonattributes);

    //  Stringa alfanumerica di max 255 caratteri contenente la "URL" del file css di personalizzazione del wizard di accesso.
    //  L’attributo "absolute" deve essere impostato a "1" se il file css si trova su di un server esterno o a "0" se è invece presente sul server di videoconferenza.
    /// "skin" field
        //$mform->addElement('text', 'skin', get_string('skin','webskill'));
        //$mform->setType('skin', PARAM_RAW);

        $mform->addElement('choosecoursefile', 'skin', get_string('skin','webskill'), null, array('maxlength' => 255, 'size' => 48));
        //$mform->setDefault('skin', $CFG->resource_defaulturl);
        $mform->addGroupRule('skin', array('value' => array(array(get_string('maximumchars', '', 255), 'maxlength', 255, 'client'))));

        $skinbutton = $mform->addElement('button', 'skinbutton', get_string('searchweb', 'resource').'...');
        $buttonattributes = array('title'=>get_string('searchweb', 'resource'), 'onclick'=>"return window.open('"
                          . "$CFG->resource_websearch', 'websearch', 'menubar=1,location=1,directories=1,toolbar=1,"
                          . "scrollbars,resizable,width=800,height=600');");
        $skinbutton->updateAttributes($buttonattributes);

//-------------------------------------------------------------------------------
        // add standard elements, common to all modules
        $features = new object();
        $features->groups           = false;
        $features->groupings        = false;
        $features->groupmembersonly = true;
        $this->standard_coursemodule_elements($features);
//-------------------------------------------------------------------------------
        // add standard buttons, common to all modules
        $this->add_action_buttons();

    }
}

?>
