<?php // $Id: restorelib.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/**
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

    //This function executes all the restore procedure about this mod
    function webskill_restore_mods($mod,$restore) {

        global $CFG;

        $status = true;

        //Get record from backup_ids
        $data = backup_getid($restore->backup_unique_code,$mod->modtype,$mod->id);

        if ($data) {
            //Now get completed xmlized object
            $info = $data->info;
            //traverse_xmlize($info);                                                                     //Debug
            //print_object ($GLOBALS['traverse_array']);                                                  //Debug
            //$GLOBALS['traverse_array']="";                                                              //Debug

            //Now, build the webskill record structure
            $webskill->course = $restore->course_id;
            $webskill->name = backup_todb($info['MOD']['#']['NAME']['0']['#']);
            $webskill->intro = backup_todb($info['MOD']['#']['INTRO']['0']['#']);
            $webskill->introformat = backup_todb($info['MOD']['#']['INTROFORMAT']['0']['#']);

            $webskill->roomid = backup_todb($info['MOD']['#']['ROOMID']['0']['#']);
            $webskill->confmanid = backup_todb($info['MOD']['#']['CONFMANID']['0']['#']);
            $webskill->emailconfman = backup_todb($info['MOD']['#']['EMAILCONFMAN']['0']['#']);
            $webskill->startdate = backup_todb($info['MOD']['#']['STARTDATE']['0']['#']);
            $webskill->enddate = backup_todb($info['MOD']['#']['ENDDATE']['0']['#']);
            $webskill->opentoblank = backup_todb($info['MOD']['#']['OPENTOBLANK']['0']['#']);
            $webskill->title = backup_todb($info['MOD']['#']['TITLE']['0']['#']);
            $webskill->descr = backup_todb($info['MOD']['#']['DESCR']['0']['#']);
            $webskill->users = backup_todb($info['MOD']['#']['USERS']['0']['#']);
            $webskill->logo = backup_todb($info['MOD']['#']['LOGO']['0']['#']);
            $webskill->skin = backup_todb($info['MOD']['#']['SKIN']['0']['#']);
            $webskill->timecreated = backup_todb($info['MOD']['#']['TIMECREATED']['0']['#']);
            $webskill->timemodified = backup_todb($info['MOD']['#']['TIMEMODIFIED']['0']['#']);

            //The structure is equal to the db, so insert the webskill
            $newid = insert_record ('webskill',$webskill);

            //Do some output
            if (!defined('RESTORE_SILENTLY')) {
                echo '<li>'.get_string('modulename','webskill').' "'.format_string(stripslashes($webskill->name),true).'"</li>';
            }
            backup_flush(300);

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,$mod->modtype,$mod->id, $newid);
            } else {
                $status = false;
            }
        } else {
            $status = false;
        }

        return $status;
    }

    //This function returns a log record with all the necessay transformations
    //done. It's used by restore_log_module() to restore modules log.
    function webskill_restore_logs($restore,$log) {

        $status = false;

        return $status;
    }
?>
