<?php  // $Id: view.php,v 1.0.0 2009/07/31 12:23:11 kordan Exp $

/*
 * This page prints a particular instance of webskill
 *
 * @author  MediaTouch 2000 srl Moodle Partner for Italy <info@mediatouch.it>
 * @version $Id: version.php,v 1.0.0 2009/07/31 kordan Exp $
 * @package mod/webskill
 */

    /// (Replace webskill with the name of your module and remove this line)

    require_once('../../config.php');
    require_once('locallib.php');

    $id = optional_param('id', 0, PARAM_INT); // course_module ID, or
    $a  = optional_param('a', 0, PARAM_INT);  // webskill instance ID

    if ($id) {
        if (! $cm = get_coursemodule_from_id('webskill', $id)) {
            error('Course Module ID was incorrect');
        }

        if (! $course = get_record('course', 'id', $cm->course)) {
            error('Course is misconfigured');
        }

        if (! $webskill = get_record('webskill', 'id', $cm->instance)) {
            error('Course module is incorrect');
        }

    } else if ($a) {
        if (! $webskill = get_record('webskill', 'id', $a)) {
            error('Course module is incorrect');
        }
        if (! $course = get_record('course', 'id', $webskill->course)) {
            error('Course is misconfigured');
        }
        if (! $cm = get_coursemodule_from_instance('webskill', $webskill->id, $course->id)) {
            error('Course Module ID was incorrect');
        }

    } else {
        error('You must specify a course_module ID or an instance ID');
    }

    require_login($course, true, $cm);

    add_to_log($course->id, "webskill", "view", "view.php?id=$cm->id", "$webskill->id");

    /// Print the page header
    $strwebskills = get_string('modulenameplural', 'webskill');
    $strwebskill  = get_string('modulename', 'webskill');

    $navlinks = array();
    $navlinks[] = array('name' => $strwebskills, 'link' => "index.php?id=$course->id", 'type' => 'activity');
    $navlinks[] = array('name' => format_string($webskill->name), 'link' => '', 'type' => 'activityinstance');

    $navigation = build_navigation($navlinks);

    print_header_simple(format_string($webskill->name), '', $navigation, '', '', true,
                  update_module_button($cm->id, $course->id, $strwebskill), navmenu($course, $cm));

    /// Print the main part of the page
    if (!isset($CFG->webskill_clientcode))
        die ('Webskill is not configured. You have to set <a href="'.$CFG->wwwroot.'/admin/settings.php?section=modsettingwebskill">Webskill general settings</a> before continue.');

    // if you didn't find a roomid specified into $webskill record try to define it now
    $testmode = false;
    if (empty($webskill->roomid) && !$testmode) {
        $xml_answer = webskill_createroom($webskill);
        if (!webskill_readxmlanswer($xml_answer, 'errorcode')) {
            $webskill->roomid = webskill_readxmlanswer($xml_answer, 'roomid');
            update_record('webskill', $webskill);
            if ($webskill->emailconfman) {
                webskill_sendemail($webskill, 'add');
            }
        }
    }

    // if you still have a missig roomid inside $webskill record declare you can not proceed
    if (empty($webskill->roomid) && !$testmode) {
        include_once('./missingroom.php');
    } else {
        include_once('./getparams.php');
        include_once('./tabs.php');
        include_once('./redirect.php');
    }

    /// Finish the page
    print_footer($course);

?>