<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Define tlive backup task
 *
 * @package    mod_tlive
 * @category   backup
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once($CFG->dirroot . '/mod/tlive/backup/moodle2/backup_tlive_stepslib.php'); /* Because it exists (must) */

/**
 * Tlive backup task that provides all the settings and steps to perform onecomplete backup of the activity
 *
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class backup_tlive_activity_task extends backup_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        /* No particular settings for this activity */
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        /* SCORM only has one structure step */
        $this->add_step(new backup_tlive_activity_structure_step('tlive_structure', 'tlive.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     *
     * @param string $content some HTML text that eventually contains URLs to the activity instance scripts
     * @return string the content with the URLs encoded
     */
    static public function encode_content_links($content) {
        global $CFG;

        $base = preg_quote($CFG->wwwroot, "/");

        /* Link to the list of tlive items */
        $search = "/(".$base."\/mod\/tlive\/index.php\?id\=)([0-9]+)/";
        $content = preg_replace($search, '$@tliveINDEX*$2@$', $content);

        /* Link to tlive view by moduleid */
        $search = "/(".$base."\/mod\/tlive\/view.php\?id\=)([0-9]+)/";
        $content = preg_replace($search, '$@tliveVIEWBYID*$2@$', $content);

        return $content;
    }
}
