<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file keeps track of upgrades to the tlive module
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/


/**
 * Tlive upgrade task *
 *
 * @param int $oldversion Version number
 * @return boolean $result Upgrade success or failed
 */
function xmldb_tlive_upgrade($oldversion=0) {

    global $CFG, $THEME, $DB;

    $dbman = $DB->get_manager();
    $result = true;

    if ($oldversion < 2014032400) {

        // Define field banner to be added to tlive.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('banner', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'logo');

        // Conditionally launch add field banner.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2014032400, 'tlive');
    }

    return $result;
}