<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Get view params of tlive module
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

defined('MOODLE_INTERNAL') OR die('not allowed');

$defaulttab = (tlive_useris_conferencemanagercandidate($cm) ||
           tlive_usercan_managelogs($cm)) ? TLIVE_TAB1 : TLIVE_NOTAB;
$currenttab  = optional_param('tab', $defaulttab, PARAM_INT);
$currentpage = optional_param('pag', 1, PARAM_INT);
switch ($currenttab) {
    case TLIVE_NOTAB:
    case TLIVE_TAB1:
    break;
    case TLIVE_TAB2:
        switch ($currentpage) {
            case TLIVE_TAB2_PAGE1:
                $currentpagename = TLIVE_TAB2_PAGE1NAME;
                break;
            case TLIVE_TAB2_PAGE2:
                $currentpagename = TLIVE_TAB2_PAGE2NAME;
                break;
            default:
                echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                echo 'I have $currentpage = '.$currentpage.'<br />';
                echo 'But the right "case" is missing<br />';
        }
    break;
    default:
        echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
        echo 'I have $currenttab = '.$currenttab.'<br />';
        echo 'But the right "case" is missing<br />';
}