<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Videoconference summary with activity completion state
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/


defined('MOODLE_INTERNAL') OR die('not allowed');

/* Course module */
$id = optional_param('id',  0,  PARAM_INT);
$context = context_course::instance($COURSE->id);

$OUTPUT->container_start(true,  'box generalbox boxaligncenter boxwidthnormal');

/* if($user_role = $DB->get_record('role_assignments', array('contextid'=>$context->id, 'userid'=>$USER->id, 'roleid'=>5))){

Print activity completion, valid only for students (except conference manager and moodle administrator) */
$blnCompletion = ($tlive->completiontlive || $tlive->completiontlivepoll || $tlive->completiontliveviewsubmit);

if ($USER->id!=$tlive->confmanid && !has_capability('moodle/site:config', $context) && $blnCompletion) {
    echo '<div align="right">'.get_string('completion', 'tlive').' ';
    if ($DB->get_record('course_modules_completion', array('coursemoduleid'=>$id, 'userid'=>$USER->id) ) ) {
        $img = 'complete.png';
    } else {
        $img = 'uncomplete.png';
    }

    echo '<img align="middle" src="'.$CFG->wwwroot.'/mod/tlive/pix/'.$img.'">';
    echo '</div>';
}

$strftime = get_string('displaytimeformat',  'tlive');
$strfdate = get_string('displaydateformat',  'tlive');
if(!$CFG->tlive_disabledate) {
	echo get_string('conference',  'tlive').userdate($tlive->startdate, $strfdate).'<br />';
	echo '<ul><li>'.get_string('starting',  'tlive').userdate($tlive->startdate, $strftime).'</li>';
	echo '<li>'.get_string('ending',  'tlive').userdate($tlive->enddate, $strftime).'</li></ul>';
}
echo '<strong>'.get_string('title',  'tlive').'</strong><div style="margin-left: 27px;">'.$tlive->name.'</div>';
echo '<strong>'.get_string('descr',  'tlive').'</strong><div style="margin-left: 27px;">'.$tlive->intro.'</div>';

if ($tlive->opentoblank) {
    echo '<div style="text-align: center; color: red;">'.get_string('willopentoblank', 'tlive').'</div>';
}

$OUTPUT->container_end();

$buttonlabel = get_string('jointlive', 'tlive');
if ($tlive->opentoblank) {
    /* echo '<form method="post" action="'.$CFG->wwwroot.'/mod/tlive/login/join.php"
     onsubmit="this.target=\'popup\'" class="clearfix">';
     onclick="this.target=\'popup\'" the last previous row is responsibe for the new window */

    echo '<form method="post" target="Teleskill Live" action="'.$CFG->wwwroot.'/mod/tlive/login/join.php"
    onsubmit="return window.open(\'\',  \'Teleskill Live\',  \'location=0, status=1, menubar=0, toolbar=0,
    resizable=1, scrollbars=1, width=1000, height=700, left=0, top=0, screenX=0, screenY=0\')" class="clearfix">';

} else {
    echo '<form method="post" action="'.$CFG->wwwroot.'/mod/tlive/login/join.php" class="clearfix">';
}
echo '<div style="text-align:center;">';
echo '<input type="hidden" name="s"    value="'.session_id().'" />';
echo '<input type="hidden" name="id"   value="'.$cm->id.'" />';
echo '<input type="submit" name="goto" value="'.$buttonlabel.'" title="'.$buttonlabel.'" />';
?>

</div>
</form>
