<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Retrieve poll sessions data
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
defined('MOODLE_INTERNAL') OR die('not allowed');
/*
 *$id, $rsid, $lsid, $psid, $pid, $opt declared in view.php
 */
$strfdate = get_string('displaydateformat', 'tlive');
$strftime = get_string('displaytimeformat', 'tlive');
/* Poll sessions list */
if ($pid != 0 && $rsid!=0) {

    $OUTPUT->box_start();
    echo "<h3>".get_string('poll_sessions', 'tlive')."</h3>";
    $tablepolls = new html_table();
    $tablepolls->head  = array(get_string('poll_session', 'tlive'), get_string('start', 'tlive'), get_string('end', 'tlive'));
    $tablepolls->data = array();
    $tablepolls->id = 'poll_sessions';
    $tablepolls->tablealign = 'center';
    $tablepolls->width = '80%';

    if (!$pollssessions = $DB->get_records('tlive_polls_sessions', array('pollid' => $pid), 'opendate, closedate ASC')) {

        echo get_string('nosessionperpoolavailable', 'tlive');

    } else {

        foreach ($pollssessions as $p) {
            $pollsessiontext = "<a href=\"?id=$id&tab=2&rsid=$rsid&psid=$p->pollsessionid&opt=answers\">";
            $pollsessiontext.= get_string("poll_session",  "tlive").' '. userdate($p->opendate, $strfdate)."</a>";
            $start = userdate($p->opendate, $strftime);
            $end = ($p->closedate != 0) ? userdate($p->closedate, $strftime) : '';
            $aux = array($pollsessiontext, $start, $end);
            array_push($tablepolls->data, $aux);
        }

    }
    echo html_writer::table($tablepolls);
    $OUTPUT->box_end();
}
/* Print details flag (relative to a single poll session) */
if ($psid != 0 && $rsid!=0) {

    $pollrecord = $DB->get_record('tlive_polls_sessions', array('pollsessionid'=>$psid));

    /* Include JQuery libraries to print chart */
    $PAGE->requires->data_for_js('dirroot', $CFG->wwwroot);
    $PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/charts/jquery-1.9.1.min.js') );
    $PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/charts/highcharts.js') );
    $PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/charts/answers-chart-pie.js') );

    /* Load user language */
    $lang = $USER->lang;
    $PAGE->requires->js( new moodle_url ($CFG->wwwroot . '/mod/tlive/javascript/charts/lang/'.$lang.'.js') );

    $OUTPUT->box_start();
    $query = "SELECT p.question, ps.opendate, ps.closedate
    FROM {tlive_polls_sessions} as ps
    INNER JOIN {tlive_polls} as p ON ps.pollid=p.pollid
    WHERE ps.pollsessionid='$psid'";
    $poll = $DB->get_record_sql($query);
    echo "<h3>".get_string('question', 'tlive').": $poll->question,   ".get_string('poll_session', 'tlive').
    ' '.userdate($poll->opendate, $strfdate.' '.$strftime)." - ".userdate($poll->closedate, $strftime)."</h3>";

    /* Print donut chart */
    echo "<div id=\"container\" style=\"min-width: 400px;height: 400px;margin: 0 auto\"></div>";

    /* Print user table with their answers */
    $table = tlive_buildtablepolls($psid);
    $qrstr = $_SERVER["QUERY_STRING"];

    echo "<div style=\"margin-left:20%;margin-bottom:1%;\">".get_string('export', 'tlive')."
    <a target=\"_blank\" href=\"$CFG->wwwroot/mod/tlive/logs/export-table.php?$qrstr&exp=pollpdf\">
    <img src=\"$CFG->wwwroot/mod/tlive/javascript/charts/pdf.png\"></a>&nbsp;&nbsp;
    <a target=\"_blank\" href=\"$CFG->wwwroot/mod/tlive/logs/export-table.php?$qrstr&exp=pollxls\">
    <img src=\"$CFG->wwwroot/mod/tlive/javascript/charts/xls.png\"></a>
    </div>";

    echo html_writer::table($table);
    $OUTPUT->box_end();
}