<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *  This file defines the main tlive configuration form
 *
 *  It uses the standard core Moodle (>1.8) formslib. For
 *  more info about them,  please visit:
 *  http://docs.moodle.org/en/Development:lib/formslib.php
 *  Also, it's usual to use these fields:
 *   - intro: one htmlarea element to describe the activity
 *            (will be showed in the list of activities of
 *             tlive type (index.php) and in the header
 *             of the tlive main page (view.php).
 *   - introformat: The format used to write the contents
 *             of the intro field. It automatically defaults
 *             to HTML when the htmleditor is used and can be
 *             manually selected if the htmleditor is not used
 *             (standard formats are: MOODLE,  HTML,  PLAIN,  MARKDOWN)
 *             See lib/weblib.php Constants and the format_text()
 *             function for more info
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once($CFG->dirroot.'/course/moodleform_mod.php');
$PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/jquery.min.js') );
$PAGE->requires->js( new moodle_url($CFG->wwwroot . '/mod/tlive/javascript/open_calendar.js') );

/**
 * Definition of Tlive form class to add or edit a room
 *
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class mod_tlive_mod_form extends moodleform_mod {

    /**
     * This function defines form object
     *
     */
    public function definition() {

        global $COURSE,  $CFG,  $DB;

        $mform =& $this->_form;

        /* -------------------------------------------------------------------------------
         * Adding the "general" fieldset,  where all the common settings are showed */
            $mform->addElement('header',  'general',  get_string('general',  'form'));

        /* Adding the standard "name" field */
            $mform->addElement('text',  'name',  get_string('tlivename',  'tlive'),  array('size'=>'64'));
            $mform->setType('name',  PARAM_TEXT);
            $mform->addRule('name',  null,  'required',  null,  'client');
            $mform->addRule('name',  get_string('maximumchars',  '',  255),  'maxlength',  255,  'client');

        /* Adding the required "intro" field to hold the description of the instance */
            $this->add_intro_editor(true,  get_string('tliveintro',  'tlive'));

        /* Opening the "tlive" fieldset */
            $mform->addElement('header',  'tlive_specific_fs',  get_string('tlivespecific',  'tlive'));

        /*  Conference managar ID del conferencemanager
         * "conferencemanager" field
         * ugly workaround until I can't find the proper way o code it (probably in to forum php code)
         * I want the list of users with the 'mod/tlive:conferencemanagercandidate'
         * capability assigned ONLY in the context of this course */

        if ($context = context_course::instance($COURSE->id)) {
            $useinheritedcapability = false;
            if ($useinheritedcapability) {
                $users = get_users_by_capability($context, 'mod/tlive:conferencemanagercandidate',
                                                 'id, firstname, lastname', 'lastname');
                unset($temp);
                foreach ($users as $thisuser) {
                    $temp[$thisuser->id] = fullname($thisuser);
                }
            } else {

                $courseroles = get_roles_with_capability('mod/tlive:conferencemanagercandidate',  CAP_ALLOW,  $context);

                $conferencemanagers = array();
                foreach ($courseroles as $thisrole) {
                    if ($roleusers = get_role_users($thisrole->id,  $context,  false,  'u.id,  u.firstname,  u.lastname')) {
                        /* List of course participants */
                        $conferencemanagers = array_merge($conferencemanagers,  $roleusers);
                    }
                }

                unset($temp);
                foreach ($conferencemanagers as $k => $v) {
                    $temp[$v->id] = fullname($v);
                }
                if (isset($temp)) {
                    asort($temp);
                }
            }
            if (isset($temp)) {
                $mform->addElement('select', 'confmanid', get_string('conferencemanager', 'tlive'), $temp, null);
            } else {
                $mform->addElement('static', 'warning', get_string('conferencemanager', 'tlive'),
                                    get_string('missingconferencemanager', 'tlive'));
            }
        } else {
            die('badcontext at the row '.__LINE__.' of the file '.__FILE__.'<br />');
        }

        /*  send an e-mail to conference manager
         * "emailconferencemanager" field */
            $mform->addElement('checkbox',  'emailconfman',  get_string('emailconfman',  'tlive'));
            $mform->setDefault('emailconfman',  '1');
		
		
		
		/* if scheduling isn't disabled, use startdate and enddate */
		if (!$CFG->tlive_disabledate) {
		
	        /*  Start date */
	         $mform->addElement('date_selector',  'startdate',  get_string('startdate',  'tlive'));
	
	        $hour = array();
	
	        for ($i=0; $i<24; $i++) {
	            $hour[$i] = str_pad($i, 2, "0", STR_PAD_LEFT);
	        }
	
	        $minute =  array();
	
	        for ($i=0; $i<60; $i+=5) {
	            $minute[$i] = str_pad($i, 2, "0", STR_PAD_LEFT);
	        }
	
	        /*  Start and end of videoconference */
	        $grouphour = array();
	        $grouphour[]=& $mform->createElement('select',  'starthour',  '',  $hour);
	        $grouphour[]=& $mform->createElement('select',  'startminute',  '',  $minute);
	        $mform->addGroup($grouphour,  'grouphourstart',  get_string('starthour', 'tlive'),  array(' '),  false);
	
	        $now = usergetdate(time());
	
	        $mform->setDefault('starthour', $now['hours']);
	        $mform->setDefault('startminute', round($now['minutes']/5)*5);
	
	        $grouphour = array();
	        $grouphour[]=& $mform->createElement('select',  'endhour',  '',  $hour);
	        $grouphour[]=& $mform->createElement('select',  'endminute',  '',  $minute);
	        $mform->addGroup($grouphour,  'grouphourend',  get_string('endhour', 'tlive'),  array(' '),  false);
	
	        $mform->setDefault('endhour', $now['hours']+1);
	        $mform->setDefault('endminute', round($now['minutes']/5)*5);
	
	        /* Set hours and minutes loaded from db (only during editing task) */
	        $update = optional_param('update', 0, PARAM_INT);
	
	        if ($update!=0) {
	
	            $cm = $DB->get_record("course_modules",  array("id" => $update));
	            $conference = $DB->get_record("tlive",  array("id" => $cm->instance));
	
	            $start = $conference->startdate;
	            $end =  $conference->enddate;
	
	            $start = usergetdate($start);
	            $end = usergetdate($end);
	
	            $mform->setDefault('starthour', $start['hours']);
	            $mform->setDefault('startminute', $start['minutes']);
	
	            $mform->setDefault('endhour', $end['hours']);
	            $mform->setDefault('endminute', $end['minutes']);
	        }
	
	        unset($hour);
	        unset($minute);
	
	        $inputhtml = '<input type="button" style="width:50px;height:50px;border=0px;
	                      background: url(../mod/tlive/pix/calendar.png) no-repeat;
	                      background-position:center;margin-left:16%;" onClick="open_calendar();" />';
	
	        $mform->addElement('html', $inputhtml );	        
        
    	} else {
    		
    		/* if scheduling is disabled, set startdate=enddate=0 */
    		$mform->addElement('hidden',  'startdate',  0);
    		$mform->setType('startdate',PARAM_INT);
    		
    		$mform->addElement('hidden',  'enddate',  0);
    		$mform->setType('enddate',PARAM_INT);
    		
    		$mform->addElement('hidden',  'starthour',  0);
    		$mform->setType('starthour',PARAM_INT);
    		
    		$mform->addElement('hidden',  'startminute',  0);
    		$mform->setType('startminute',PARAM_INT); 
    		   		
    		$mform->addElement('hidden',  'endhour',  0);    		
    		$mform->setType('endhour',PARAM_INT);
    		
    		$mform->addElement('hidden',  'endminute',  0);
    		$mform->setType('endminute',PARAM_INT);
    		
    	}
    	
        /*  open videoconference in a new window?
         * "opentoblank" field */
        $mform->addElement('checkbox',  'opentoblank',  get_string('opentoblank',  'tlive'));
        $mform->setDefault('opentoblank',  '1');

        /* select users number */
        unset($temp);

        $temp= array();
        for ($i=1; $i<=$CFG->tlive_maxusers; $i++) {
            $temp[$i] = $i;
        }

        $mform->addElement('select',  'users',  get_string('users', 'tlive'),  $temp,  null);
        $mform->addElement('filepicker',  'logo',  get_string('logo', 'tlive'),  null);
        $mform->addElement('filepicker',  'banner',  get_string('banner', 'tlive'),  null);

        /* ------------------------------------------------------------------------------- */
            /*  add standard elements,  common to all  modules */
            $features = new object();
            $features->groups    = false;
            $features->groupings = false;
            $features->groupmembersonly = true;
            $this->standard_coursemodule_elements($features);
        /* ------------------------------------------------------------------------------- */
            /*  add standard buttons,  common to all modules */
            $this->add_action_buttons();

    }


    /**
     * Form preprocessing
     *
     * @param array $defaultvalues
     */
    public function data_preprocessing(&$defaultvalues) {

        parent::data_preprocessing($defaultvalues);

        // Set up the completion checkboxes which aren't part of standard data.
        // We also make the default value (if you turn on the checkbox) for those
        // numbers to be 1,  this will not apply unless checkbox is ticked.
        $defaultvalues['completiontlivesubmit'] = !empty($defaultvalues['completiontlive']) ? 1 : 0;
        if (empty($defaultvalues['completiontlive'])) {
            $defaultvalues['completiontlive']=1;
        }

        $defaultvalues['completiontlivepollsubmit']=
            !empty($defaultvalues['completiontlivepoll']) ? 1 : 0;
        if (empty($defaultvalues['completiontlivepoll'])) {
            $defaultvalues['completiontlivepoll']=1;
        }
    }

    /**
     * Add activity completion rules checkboxes
     *
     * @return array
     */
    public function add_completion_rules() {

        $group = array();
        $mform =& $this->_form;

        $group[] =& $mform->createElement('text',  'completiontlive',  '',  array('size' => 5));
        $group[]=&$mform->createElement('checkbox',  'completiontlivesubmit',  '',  get_string('completionsubmit',  'tlive'));

        $mform->setType('completiontlive',  PARAM_INT);
        $mform->disabledIf('completiontlive', 'completiontlivesubmit', 'notchecked');
        $mform->disabledIf('completiontlive', 'completiontlivepollsubmit', 'checked');
        $mform->disabledIf('completiontlivesubmit', 'completiontlivepollsubmit', 'checked');
        $mform->disabledIf('completiontlivesubmit', 'completiontliveviewsubmit', 'checked');
        $mform->addGroup($group,  'completiontlivegroup',  get_string('completiontlive', 'tlive'),  array(' '),  false);
        $mform->addHelpButton('completiontlivegroup', 'completiontlivegroup', 'tlive');

        $group = array();

        $group[] =& $mform->createElement('text',  'completiontlivepoll',  '',  array('size' => 5));
        $group[]=&$mform->createElement('checkbox',  'completiontlivepollsubmit',  '',  get_string('completionsubmit',  'tlive'));
        $mform->setType('completiontlivepoll',  PARAM_INT);
        $mform->disabledIf('completiontlivepoll', 'completiontlivepollsubmit', 'notchecked');
        $mform->disabledIf('completiontlivepoll', 'completiontlivesubmit', 'checked');
        $mform->disabledIf('completiontlivepollsubmit', 'completiontlivesubmit', 'checked');
        $mform->disabledIf('completiontlivepollsubmit', 'completiontliveviewsubmit', 'checked');
        $mform->addGroup($group,  'completiontlivepollgroup',  get_string('completiontlivepoll', 'tlive'),  array(' '),  false);
        $mform->addHelpButton('completiontlivepollgroup', 'completiontlivepollgroup', 'tlive');

        $group = array();

        $group[]=&$mform->createElement('checkbox', 'completiontliveviewsubmit', '', get_string('completionsubmit', 'tlive'));
        $mform->disabledIf('completiontliveviewsubmit', 'completiontliveviewsubmit', 'notchecked');
        $mform->disabledIf('completiontliveviewsubmit', 'completiontlivesubmit', 'checked');
        $mform->disabledIf('completiontliveviewsubmit', 'completiontlivepollsubmit', 'checked');
        $mform->addGroup($group, 'completiontliveviewgroup', get_string('completiontliveviewgroup', 'tlive'), array(' '), false);
        $mform->addHelpButton('completiontliveviewgroup', 'completiontliveviewgroup', 'tlive');

        return array('completiontlivegroup', 'completiontlivepollgroup', 'completiontliveviewgroup');

    }

    /**
     * Called during validation. Override to indicate, based on the data,
     * whether a custom completion rule is enabled (selected).
     *
     * @param array $data Completion rules array
     * @return boolean True if one or more rules is enabled, false if none are; default returns false
     */
    public function completion_rule_enabled($data) {
        return ((!empty($data['completiontlivesubmit']) && $data['completiontlive']!=0) ||
        (!empty($data['completiontlivepollsubmit']) && $data['completiontlivepoll']!=0) ||
        (!empty($data['completiontliveviewsubmit'])) );
    }

    /**
     * This function get data from the form
     *
     * @return array $data
     */
    public function get_data() {

        $data = parent::get_data();

        if (!$data) {
            return $data;
        }

        /*  Turn off completion settings if the checkboxes aren't ticked */
        $autocompletion = !empty($data->completion) and
                                $data->completion==COMPLETION_TRACKING_AUTOMATIC;

        if (empty($data->completiontlivesubmit) || !$autocompletion) {
            $data->completiontlive=0;
        }

        if (empty($data->completiontlivepollsubmit) || !$autocompletion) {
            $data->completiontlivepoll=0;
        }

        if (empty($data->completiontliveviewsubmit) || !$autocompletion) {
            $data->completiontliveviewsubmit=0;
        }

        return $data;
    }

}
