<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Redirect tabs page
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

defined('MOODLE_INTERNAL') OR die('not allowed');

switch ($currenttab) {
    case TLIVE_NOTAB:
    case TLIVE_TAB1:
        include_once('./login/getaccess.php');
        break;
    case TLIVE_TAB2:
        switch ($currentpage) {
            case TLIVE_TAB2_PAGE1:
                include_once('./logs/upd_stats.php');
                include_once('./logs/logs.php');
                include_once('./logs/polls.php');
                include_once('./logs/poll_sessions.php');
                include_once('./logs/user_sessions.php');
                break;
            case TLIVE_TAB2_PAGE2:
                include_once('./logs/channeldata.php');
                break;
            default:
                echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
                echo 'I have $currentpage = '.$currentpage.'<br />';
                echo 'But the right "case" is missing<br />';
        }
        break;
    default:
        echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
        echo 'I have $currenttab = '.$currenttab.'<br />';
        echo 'But the right "case" is missing<br />';
}