<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Show week calendar page with events scheduled
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once(dirname(__FILE__) . '/../../../config.php');

/* Check if user is logged */
require_login();
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN""http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>

<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <?php
  /* Select language file */
    $lang = $USER->lang;
    echo "<script type='text/javascript' src='lang/".$lang.".js'></script>";
?>
    <link rel='stylesheet' type='text/css' href='reset.css' />
    <link rel='stylesheet' type='text/css' href='../javascript/blitzer/jquery-ui.css' />
    <link rel='stylesheet' type='text/css' href='jquery.weekcalendar.css' />
    <link rel='stylesheet' type='text/css' href='calendar.css' />

    <script type='text/javascript' src='../javascript/jquery.min.js'></script>
    <script type='text/javascript' src='../javascript/jquery-ui.min.js'></script>
    <script type='text/javascript' src='jquery.weekcalendar.js'></script>
    <script type='text/javascript' src='calendar.js'></script>
</head>
<body>
    <div id='calendar'></div>
    <div id="event_edit_container">
        <form>
            <input type="hidden" />
            <ul>
                <li>
                   <span><?php echo get_string('conference_date', 'tlive');?> </span><span class="date_holder"></span>
                </li>
                <li>
                   <label for="start"><?php echo get_string('label_start', 'tlive');?></label><select name="start"><option value="">
                   <?php echo get_string('label_select_start', 'tlive');?></option></select>
                </li>
                <li>
                   <label for="end"><?php echo get_string('label_end', 'tlive');?> </label><select name="end"><option value="">
                   <?php echo get_string('label_select_end', 'tlive');?></option></select>
                </li>
                <li>
                   <label for="users"><?php echo get_string('label_users', 'tlive');?></label><input type="text" name="users" />
                </li>
            </ul>
        </form>
    </div>

</body>
</html>