<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This page load events from db and and encode a json passed to JQuery Week Calendar
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once(dirname(__FILE__) . '/../../../config.php');
require_once(dirname(__FILE__) . '/../locallib.php');

$res = $DB->get_records_sql('SELECT id, name, startdate, enddate, users FROM {tlive}');
$arrayjson = array();

/* Load events already scheduled, not writable */

$count=1;
$update = optional_param('update', 0, PARAM_INT);

if (!empty($res)) {

    foreach ($res as $r) {

        if ($r->id!=$update) {

            $arrayjson[] = array(
            'id'=>$count,
            'title'=>$r->name,
            'start'=>tlive_get_isodatetime($r->startdate),
            'end'=>tlive_get_isodatetime($r->enddate),
            'users'=>$r->users,
            'readonly'=>'true'
            );

            $count++;
        }

    }
}

/* Load temporary event created at the end of list
 * if already inserted, load its title from db, else print "New event"
 */

$titleupdate = $DB->get_record('tlive', array('id' => $update));
$title="";

if (!empty($titleupdate->name)) {
    $title = $titleupdate->name;
} else {
    $title= get_string('new_event', 'tlive');
}


if (!empty($_GET)) {

    $start = optional_param('s', 0, PARAM_TEXT);
    $end = optional_param('e', 0, PARAM_TEXT);
    $users = optional_param('u', 0, PARAM_INT);

    /* If user time zone is not equal to server local time set default time zone as user time zone */
    $timezone = usertimezone();
    if ($timezone!= get_string('serverlocaltime')) {
        date_default_timezone_set($timezone);
    }

    $start =  strtotime($start);
    $end =  strtotime($end);

    $arrayjson[] = array(
        'id'=>$count,
        'title'=>$title,
        'start'=>tlive_get_isodatetime($start),
        'end'=>tlive_get_isodatetime($end),
        'users'=>$users,
        'readonly'=>'false'
        );
}

echo json_encode($arrayjson);

