<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
 
/**
 * The room_join event.
 *
 * @package    mod_tlive
 * @copyright  2015 Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace mod_tlive\event;
defined('MOODLE_INTERNAL') || die();
/**
 * The join room event class.
 *
 * @property-read array $other {
 *      Extra information about event.
 *
 *      - PUT INFO HERE
 * }
 *
 * @since     Moodle 29
 * @copyright 2015 Teleskill Italia S.r.l
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
class stats_update extends \core\event\base {
    protected function init() {
        $this->data['crud'] = 'c'; // c(reate), r(ead), u(pdate), d(elete)
        $this->data['edulevel'] = self::LEVEL_PARTICIPATING;
        $this->data['objecttable'] = 'tlive';       
    }
 
    public static function get_name() {
        return get_string('eventstats_update', 'mod_tlive');
    }
 
    public function get_description() {
        return "Room statistics with id {$this->objectid} updated.";
    }
 
    public function get_url() {
        return new \moodle_url('mod/tlive/view.php?', array('id' => $this->contextinstanceid, 'tab' => 2));
    }
 
   
     /**
     * Return the legacy event log data.
     *
     * @return array|null
     */
    protected function get_legacy_logdata() {
    	// Override if you are migrating an add_to_log() call.
        return array($this->courseid, 'tlive', 'upd statistics', "view.php?id=".$this->contextinstanceid."&tab=2", $this->objectid,
            $this->contextinstanceid);
    }
}