<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file keeps track of upgrades to the tlive module
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/


/**
 * Tlive upgrade task *
 *
 * @param int $oldversion Version number
 * @return boolean $result Upgrade success or failed
 */
function xmldb_tlive_upgrade($oldversion=0) {

    global $CFG, $THEME, $DB;

    $dbman = $DB->get_manager();
    $result = true;

    if ($oldversion < 2014032400) {

        // Define field banner to be added to tlive.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('banner', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'logo');

        // Conditionally launch add field banner.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2014032400, 'tlive');
    }
    
    if ($oldversion < 2017030200) {
    	
    	$query = "UPDATE {logstore_standard_log} SET eventname=? WHERE action=? AND target=? AND component=?";
    	$DB->execute($query, array("\\mod_tlive\\event\\stats_update","update", "stats", "mod_tlive") ); 
    	
    	$query = "UPDATE {logstore_standard_log} SET eventname=? WHERE action=? AND target=? AND component=?"	;
    	$DB->execute($query, array("\\mod_tlive\\event\\room_join", "join", "room", "mod_tlive") );
    	
    	
    	if (file_exists($CFG->dirroot.'/mod/tlive/classes/event/join_room.php') ) {
    		unlink($CFG->dirroot.'/mod/tlive/classes/event/join_room.php');    		
    	} 
    	
    	if (file_exists($CFG->dirroot.'/mod/tlive/classes/event/update_stats.php') ) {
    		unlink($CFG->dirroot.'/mod/tlive/classes/event/update_stats.php');    		
    	}
    	
    	// Tlive savepoint reached.
        upgrade_mod_savepoint(true, 2017030200, 'tlive');
    	
    }
    
    if ($oldversion < 2017040100) {
    	
    	// Define field banner to be added to tlive.
        $table = new xmldb_table('tlive');
        $field = new xmldb_field('avquality', XMLDB_TYPE_INTEGER, '2', null, XMLDB_NOTNULL, null, '0', null);

        // Conditionally launch add field banner.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $table = new xmldb_table('tlive_rooms');
        $field = new xmldb_field('lastreccheck', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null );
    	
    	if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $table = new xmldb_table('tlive_user_sessions');
        $field = new xmldb_field('idguest', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', null);
    	
    	if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }            
        
        $table = new xmldb_table('tlive_guest_users');
        $table->add_field('id', XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, XMLDB_SEQUENCE, null, null);
        $table->add_field('firstname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, null);
        $table->add_field('lastname', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'), null, null);
    	
    	$dbman->create_table($table);
    	
    	$table = new xmldb_table('tlive_recs');
    	$table->add_field('recid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('roomid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('title', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
    	$table->add_field('status', XMLDB_TYPE_INTEGER, '2', null, null, null, null, null, null);
    	$table->add_field('timecreated', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	$table->add_field('duration', XMLDB_TYPE_INTEGER, '10', null, null, null, null, null);
    	
    	$dbman->create_table($table);
    	
    	$table = new xmldb_table('tlive_recs_files');
    	$table->add_field('fileid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('recid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null, null);
    	$table->add_field('format', XMLDB_TYPE_INTEGER, '2', null, null, null, null, null);
    	$table->add_field('url', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);
    	$table->add_field('scorm', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', null);
    	$table->add_field('zip', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0', null);
    	
    	$dbman->create_table($table);
    
    }
    
    if ($oldversion < 2017050100) {
    	
    	$query = "SHOW INDEXES FROM {tlive_recs} WHERE Key_name = 'PRIMARY'";
    	if(!$DB->get_record_sql($query)) {
	    	$query = "ALTER TABLE {tlive_recs} ADD PRIMARY KEY (recid)";
	    	$DB->execute($query);
	    }
	    
	    $query = "SHOW INDEXES FROM {tlive_recs_files} WHERE Key_name = 'PRIMARY'";
    	if(!$DB->get_record_sql($query)) {	    
    		$query = "ALTER TABLE {tlive_recs_files} ADD PRIMARY KEY (fileid)";
    		$DB->execute($query);
    	}
    	
    	upgrade_mod_savepoint(true, 2017050100, 'tlive');
    }
    
    if($oldversion < 2018010800) {
    	
    	// Define field banner to be added to tlive.
        $table = new xmldb_table('tlive_guest_users');
        $field = new xmldb_field('email', XMLDB_TYPE_CHAR, '255', null, null, null, null, null);

        // Conditionally launch add field email.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }	
        
        upgrade_mod_savepoint(true, 2018010800, 'tlive');      
        
    	
    }
    
    
    

    return $result;
}