<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Index of tlive module
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
require_once('../../config.php');
require_once('lib.php');
require_once('locallib.php');

$id = required_param('id', PARAM_INT);  /* Course */

if (! $course = $DB->get_record('course', array('id' => $id))) {
    error('Course ID is incorrect');
}

$url = new moodle_url('/mod/tlive/index.php', array('course' => $course->id));
$PAGE->set_url($url);
require_course_login($course);
add_to_log($course->id, "tlive", "view all", "index.php?id=$course->id", "");

/* Get all required stringstlive */
$strtlives = get_string('modulenameplural', 'tlive');
$strtlive  = get_string('modulename', 'tlive');

/* Print the header */
$PAGE->navbar->add($strtlives);
$PAGE->set_title($strtlive);
$PAGE->set_heading($course->fullname);
echo $OUTPUT->header();

/*  Get all the appropriate data */
if (! $tlives = get_all_instances_in_course('tlive', $course)) {
    notice('There are no instances of tlive', "../../course/view.php?id=$course->id");
    die;
}

/* Print the list of instances (your module will probably extend this) */
$timenow  = time();
$strname  = get_string('name');
$strweek  = get_string('week');
$strtopic = get_string('topic');
$table = new html_table();
$table->tablealign = 'center';

if ($course->format == 'weeks') {
    $table->head  = array ($strweek, $strname);
    $table->align = array ('center', 'left');
} else if ($course->format == 'topics') {
    $table->head  = array ($strtopic, $strname);
    $table->align = array ('center', 'left', 'left', 'left');
} else {
    $table->head  = array ($strname);
    $table->align = array ('left', 'left', 'left');
}

foreach ($tlives as $tlive) {

    if (!$tlive->visible) {
        /* Show dimmed if the mod is hidden */
        $link = '<a class="dimmed" href="view.php?id='.$tlive->coursemodule.'">'.format_string($tlive->name).'</a>';
    } else {
        /* Show normal if the mod is visible */
        $link = '<a href="view.php?id='.$tlive->coursemodule.'">'.format_string($tlive->name).'</a>';
    }

    if ($course->format == 'weeks' or $course->format == 'topics') {
        $table->data[] = array ($tlive->section, $link);
    } else {
        $table->data[] = array ($link);
    }
}
$OUTPUT->heading($strtlives);
echo html_writer::table($table);

/* Finish the page */
echo $OUTPUT->footer($course);