<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Videoconference summary with activity completion state
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

defined('MOODLE_INTERNAL') OR die('not allowed');

/* Course module */
$id = optional_param('id',  0,  PARAM_INT);
$updrecs = optional_param('upd_recs', 0, PARAM_INT);
$context = context_course::instance($COURSE->id);

$OUTPUT->container_start(true,  'box generalbox boxaligncenter boxwidthnormal');

/* if($user_role = $DB->get_record('role_assignments', array('contextid'=>$context->id, 'userid'=>$USER->id, 'roleid'=>5))){

Print activity completion, valid only for students (except conference manager and moodle administrator) */
$blnCompletion = ($tlive->completiontlive || $tlive->completiontlivepoll || $tlive->completiontliveviewsubmit);
$now = new DateTime("now", core_date::get_user_timezone_object());
$now = $now->getTimeStamp();
$blnRoomAccess =  ($now < $tlive->enddate);
$submit_class = '';

if (!isguestuser() &&  $USER->id!=$tlive->confmanid && !has_capability('moodle/site:config', $context) && $blnCompletion) {
    echo '<div align="right">'.get_string('completion', 'tlive').' ';
    if ($DB->get_record('course_modules_completion', array('coursemoduleid'=>$id, 'userid'=>$USER->id) ) ) {
        $img = 'complete.png';
    } else {
        $img = 'uncomplete.png';
    }
    echo '<img align="middle" src="'.$CFG->wwwroot.'/mod/tlive/pix/'.$img.'">';
    echo '</div>';
}

//Aggiornamento delle rec forzato lato docente
if (tlive_usercan_managelogs($cm) && !$blnRoomAccess && $CFG->tlive_enable_recs) { ?>
	
	<form style="text-align:right" method="post" action="<?php echo $CFG->wwwroot.'/mod/tlive/view.php?id='.$id;?>">
	<input type="hidden" name="upd_recs" value="1">
	<input type="submit" value="<?php echo get_string('recs_update', 'tlive');?>">
	</form>	

<?php 
	
	if ($updrecs) {
		tlive_checkroomrecs($tlive, true);	
	}
}

$strftime = get_string('displaytimeformat',  'tlive');
$strfdate = get_string('displaydateformat',  'tlive');

if(!$CFG->tlive_disabledate) {
	echo get_string('conference',  'tlive').userdate($tlive->startdate, $strfdate).'<br />';
	echo '<ul><li>'.get_string('starting',  'tlive').userdate($tlive->startdate, $strftime).'</li>';
	echo '<li>'.get_string('ending',  'tlive').userdate($tlive->enddate, $strftime).'</li></ul>';
}
echo '<strong>'.get_string('title',  'tlive').'</strong><div style="margin-left: 27px;">'.$tlive->name.'</div>';
echo '<strong>'.get_string('descr',  'tlive').'</strong><div style="margin-left: 27px;">'.$tlive->intro.'</div>';

$OUTPUT->container_end();
?>

<div class="form-container">

<?php 

if($blnRoomAccess) {
	$submit_id = 'goto';
	$buttonlabel = get_string('jointlive', 'tlive');

	if(isguestuser()) {
		$form_action = $CFG->wwwroot.'/mod/tlive/login/join_guest.php';
	} else {
		$form_action = $CFG->wwwroot.'/mod/tlive/login/join.php';
	}
} else {
	
	$buttonlabel = get_string('joinrecs','tlive');
	$submit_id = 'goto-rec';
	$form_action = $CFG->wwwroot.'/mod/tlive/login/recs.php';	
	
	if($CFG->tlive_enable_recs) {	
		
		//tlive_checkroomrecs($tlive);
		
		$blnRecs = $DB->get_records('tlive_recs', array('roomid' => $tlive->roomid));
		
	} else {
		$blnRecs = false;
	}
		
	echo '<p class="notice">'.get_string('notice_conference_end', 'tlive').'</p>';	
}


if ($tlive->opentoblank) {
   
    /*echo '<form id="join" method="post" target="Teleskill Live" action="'.$form_action.'"
    onsubmit="window.open(\'\',  \'Teleskill Live\',  \'location=0, status=1, menubar=0, toolbar=0,
    resizable=1, scrollbars=1, width=1000, height=700, left=0, top=0, screenX=0, screenY=0\');" class="clearfix">';*/
    
    echo '<form id="join" method="post" target="_blank" action="'.$form_action.'" target="_blank" class="clearfix">';

} else {
    echo '<form id="join" method="post" action="'.$form_action.'" class="clearfix">';
}
?>

<?php 
if(isguestuser() && $blnRoomAccess) {	
	if(!isset($SESSION->tlive_guest_id)) {
		echo '<p>'.get_string('guest_form_desc','tlive').'<p>';
		echo '<label for="firstname">'.get_string('firstname').'</label><input type="text" name="firstname" value="" /><br/>';
		echo '<label for="lastname">'.get_string('lastname').'</label><input type="text" name="lastname" value="" /><br/>';
		echo '<label for="email">'.get_string('email').'</label><input type="text" name="email" value="" /><br/>';
	}
}

echo '<input type="hidden" name="s"    value="'.session_id().'" />';
echo '<input type="hidden" name="id"   value="'.$cm->id.'" />';

if ($blnRoomAccess || (!$blnRoomAccess && $blnRecs)) {
	
	echo '<input type="button" id="'.$submit_id.'" name="goto" value="'.$buttonlabel.'" title="'.$buttonlabel.'" />';
	echo '<div id="guest-notice"></div>';
}

?>
</form>

<?php 
if ($tlive->opentoblank && $blnRoomAccess) {
    echo '<div style="margin-top:10px;color: red;">'.get_string('willopentoblank', 'tlive').'</div>';}
?>

</div>




