<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Join videconference room
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../../config.php');
require_once('../locallib.php');


$id      = required_param('id',  PARAM_INT); /* course_module ID,  or */

if ($id) {
    if (! $cm = get_coursemodule_from_id('tlive',  $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = $DB->get_record('course',  array('id' => $cm->course))) {
        error('Course is misconfigured');
    }

    if (! $tlive = $DB->get_record('tlive',  array('id' => $cm->instance))) {
        error('Course module is incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

$url = new moodle_url('/mod/tlive/login/join.php',  array('id' => $cm->id ));
require_login($course,  true,  $cm);
$PAGE->set_url($url);
$pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
$PAGE->set_title($pagetitle);
$PAGE->set_heading($course->fullname);

echo $OUTPUT->header();


$xmlanswer = tlive_enableuser($tlive);
if (tlive_readxmlanswer($xmlanswer,  'errorcode')) {

    /* Print the page header */
    /*$strtlives = get_string('modulenameplural',  'tlive');
    $strtlive  = get_string('modulename',  'tlive');

    $navlinks = array();
    $navlinks[] = array('name' => $strtlives,  'link' => "index.php?id=$course->id",  'type' => 'activity');
    $navlinks[] = array('name' => format_string($tlive->name),  'link' => '',  'type' => 'activityinstance');
    $navigation = build_navigation($navlinks);
    $pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
    $PAGE->set_title($pagetitle);
    $PAGE->set_heading($course->fullname);*/
   
	$OUTPUT->box_start();
    /* Print the main part of the page */
    //print_container_start(true,  'box generalbox boxaligncenter boxwidthnormal');
    $a = tlive_readxmlanswer($xmlanswer,  'errormessage');
    print_string('notjoined',  'tlive',  $a);
    //print_container_end();
    $OUTPUT->box_end();

} else {

    $url = tlive_readxmlanswer($xmlanswer,  'url');
    
    $event = \mod_tlive\event\room_join::create(array(
	    'objectid' => $tlive->id,
	    'context' => context_module::instance($cm->id)
	));
	$event->trigger();
    //add_to_log($course->id,  "tlive",  "join",  "login/join.php?id=$cm->id&s=$session",  "$tlive->id");

    /* Updating activity completion for current user, if is enabled completion activity rule on first access to videoconference */

    $completion = new completion_info($course);

    if ($completion->is_enabled($cm) && ($tlive->completiontliveviewsubmit) ) {

        $completion->update_state($cm, COMPLETION_COMPLETE, $USER->id);
        
    }

    redirect($url,  null,  0);
}


echo $OUTPUT->footer();