<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Join videconference room
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../../config.php');
require_once('../locallib.php');


$id      = required_param('id',  PARAM_INT); /* course_module ID,  or */
$firstname = optional_param('firstname','', PARAM_ALPHANUMEXT);
$lastname = optional_param('lastname', '', PARAM_ALPHANUMEXT);
$email = optional_param('email', '', PARAM_EMAIL );
$error = array();

if ($id) {
    if (! $cm = get_coursemodule_from_id('tlive',  $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = $DB->get_record('course',  array('id' => $cm->course))) {
        error('Course is misconfigured');
    }

    if (! $tlive = $DB->get_record('tlive',  array('id' => $cm->instance))) {
        error('Course module is incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

require_login($course,  true,  $cm);


$url = new moodle_url('/mod/tlive/login/join_guest.php',  array('id' => $cm->id ));
$PAGE->set_url($url);
$pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
$PAGE->set_title($pagetitle);
$PAGE->set_heading($course->fullname);

echo $OUTPUT->header();
/* Print the main part of the page */
echo $SESSION->tlive_guest_id;


if (!isset($SESSION->tlive_guest_id)) {	
	
	if(empty($firstname) || empty($lastname) || empty($email)) {		
		$u = $CFG->wwwroot.'/mod/tlive/view.php?id='.$id;			
		$error[]  = get_string('err_form_guest', 'tlive', $u);		
		
	
	} else {
	
		$timecreated = new DateTime("now", core_date::get_user_timezone_object());
		
		$record = new stdClass();		
		$record->firstname = $firstname;
		$record->lastname = $lastname;
		$record->email = $email;
		$record->timecreated = $timecreated->getTimeStamp();	
		
		$guest_id = $DB->insert_record('tlive_guest_users', $record);
		
		$SESSION->tlive_guest_id = $guest_id;
		$SESSION->tlive_guest_firstname = $firstname;
		$SESSION->tlive_guest_lastname = $lastname;
		$SESSION->tlive_guest_email = $email;
	
	}
	
} else {
	
	$guest_id = $SESSION->tlive_guest_id;
	$firstname = $SESSION->tlive_guest_firstname;
	$lastname = $SESSION->tlive_guest_lastname;
	$email = $SESSION->tlive_guest_email;
	
}


if(count($error) > 0) {
	$OUTPUT->box_start();
	
	foreach($error as $e) {
		echo '<p>'.$e.'</p>';
	}	
	
	$OUTPUT->box_end();
	
	
} else {

	$user_data = new stdClass();
	$user_data->roomid = $tlive->roomid;
	$user_data->firstname = $firstname; 
	$user_data->lastname = $lastname; 
	$user_data->email = $email;
	$user_data->guest_id = 'guest_'.$guest_id;
	
	$xmlanswer = tlive_enableuser_guest($user_data);
	
	if (tlive_readxmlanswer($xmlanswer,  'errorcode')) {	
		
 		 $a = tlive_readxmlanswer($xmlanswer,  'errormessage');
    	print_string('notjoined',  'tlive',  $a);	    
	
	} else {
	
	    $url = tlive_readxmlanswer($xmlanswer,  'url');
	    
	    $event = \mod_tlive\event\room_join::create(array(
		    'objectid' => $tlive->id,
		    'context' => context_module::instance($cm->id),
		    'other' => array(
		    	'guest_name' => ($firstname. ' '. $lastname)
		    )
		));
		$event->trigger();    
	
	    redirect($url,  null,  0);
	}

}


	
echo $OUTPUT->footer();
	