<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Join videconference room
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../../config.php');
require_once('../locallib.php');


$id      = required_param('id',  PARAM_INT); /* course_module ID,  or */
$recid = required_param('recid',  PARAM_INT);
$error = array();

if ($id) {
    if (! $cm = get_coursemodule_from_id('tlive',  $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = $DB->get_record('course',  array('id' => $cm->course))) {
        error('Course is misconfigured');
    }

    if (! $tlive = $DB->get_record('tlive',  array('id' => $cm->instance))) {
        error('Course module is incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

require_login($course,  true,  $cm);

$PAGE->requires->css('/mod/tlive/css/video-js.css');
$PAGE->requires->js('/mod/tlive/javascript/video.js', true);
$PAGE->requires->js('/mod/tlive/javascript/videojs-ie8.min.js', true);
$PAGE->requires->css(new moodle_url('/mod/tlive/css/style.css'));

$url = new moodle_url('/mod/tlive/login/rec.php',  array('id' => $cm->id ));
$PAGE->set_url($url);
$pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
$PAGE->set_title($pagetitle);
$PAGE->set_heading($course->fullname);

//get rec data
$rec = $DB->get_record('tlive_recs', array('recid'=>$recid) );
$recs = $DB->count_records('tlive_recs', array('roomid' =>  $tlive->roomid));

echo $OUTPUT->header();

if($rec) {

	//get rec files
	$files = $DB->get_records('tlive_recs_files', array('recid'=>$recid, 'zip'=> 0, 'scorm' => 0) );
	
	
	/* Print the main part of the page */
	
	?>
	
	<h2><?php echo $pagetitle. ' - '.get_string('recorddescription','tlive').$rec->title;?></h2>

<?php 	
	if($files) { ?>
		<div class="rec-container">
			<video id="rec-video" class="video-js vjs-big-play-centered " controls preload="auto" width="<?php echo $CFG->tlive_rec_player_width;?>" height="<?php echo $CFG->tlive_rec_player_height;?>"
			   data-setup='{"fluid": <?php echo $CFG->tlive_rec_player_responsive;?>}'>	
			   <?php foreach($files as $file) {    
			    	
			    	switch($file->format) {
			    			    		
			    		case TLIVE_REC_FORMAT_MP4: 
			    			$type = 'video/mp4';
			    			break;	
			    		
			    		case TLIVE_REC_FORMAT_WEBM: 
			    			$type = 'video/webm';
			    			break;	
			    		default:
			    			$type = 'video/mp4';	    		
			    	} ?>
			    	
			    	<source src="<?php echo $file->url;?>" type='<?php echo $type;?>'>    
			    		
			   <?php } ?> 		
			    <p class="vjs-no-js">
			      To view this video please enable JavaScript, and consider upgrading to a web browser that supports HTML5 video</a>
			    </p>
			  </video>
		</div>	  
	<?php if ($recs > 1) { ?>
		  <p class="back-to-recs"><a href="recs.php?id=<?php echo $id?>"> <<  <?php echo get_string('goback_recs','tlive');?></a></p>
    <?php } else { ?>
    		<p class="back-to-recs"><a href="<?php echo $CFG->wwwroot.'/mod/tlive/view.php?id='.$id;?>"> << <?php echo get_string('goback','tlive');?></a></p>
   	<?php }		
	} else {
		echo '<p class="notice" style="margin-top:30px;">'.get_string('recnotavailable', 'tlive').'</p>';	
	}
	
} else {
	echo '<p class="notice" style="margin-top:30px;">'.get_string('recnotavailable', 'tlive').'</p>';	
}
	
echo $OUTPUT->footer();
	