<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Join videconference room
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../../config.php');
require_once('../locallib.php');


$id      = required_param('id',  PARAM_INT); /* course_module ID,  or */
$error = array();

if ($id) {
    if (! $cm = get_coursemodule_from_id('tlive',  $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = $DB->get_record('course',  array('id' => $cm->course))) {
        error('Course is misconfigured');
    }

    if (! $tlive = $DB->get_record('tlive',  array('id' => $cm->instance))) {
        error('Course module is incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

require_login($course,  true,  $cm);

$url = new moodle_url('/mod/tlive/login/rec.php',  array('id' => $cm->id ));
$PAGE->set_url($url);
$PAGE->requires->css(new moodle_url('/mod/tlive/css/style.css'));
$pagetitle = strip_tags($course->shortname.': '.format_string($tlive->name));
$PAGE->set_title($pagetitle);
$PAGE->set_heading($course->fullname);

$strfdate = get_string('displaydateformat',  'tlive');
$strftime = get_string('displaytimeformat',  'tlive');

echo $OUTPUT->header();

if(!$CFG->tlive_enable_recs) {	
	
	echo '<p class="notice">'.get_string('recs_not_enabled','tlive').'</p>';
	
} else { 

	//recupero delle rec disponibili
	$recs = $DB->get_records('tlive_recs', array('roomid'=>$tlive->roomid));
	
	if(count($recs) == 1) {
		
		$rec = reset($recs);
		
		$rec_url = new moodle_url('/mod/tlive/login/rec.php',  array('id' => $cm->id, 'recid'=> $rec->recid));
		
		redirect($rec_url);
	} else { ?>
		
	<h2><?php echo $pagetitle;?> Elenco registrazioni</h2>
	
	<table width="100" class="recs-list">
		<thead>
			<tr>
				<th><?php echo get_string('rec_title','tlive');?></th>
				<th><?php echo get_string('conference_date','tlive');?></th>
				<th><?php echo get_string('rec_view','tlive');?></th>
			</tr>
		</thead>
		<?php foreach($recs as $rec) {?>
			
			<tr>
				<td style="width:40%;"><?php echo $rec->title;?></td>
				<td><?php echo userdate($rec->timecreated, get_string('displaydateformat',  'tlive')).' '. userdate($rec->timecreated, get_string('displaytimeformat',  'tlive'));?></td>
				<td><a href="rec.php?id=<?php echo $id?>&recid=<?php echo $rec->recid;?>"><img src="<?php echo new moodle_url('/mod/tlive/pix/play.png');?>"></a></td>
			</tr>
		
		
		<?php 
		}
		?>
	
	</table>	
	
<?php }

}
	
echo $OUTPUT->footer();
	