<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Export from html tables to pdf/excel 
 * 
 * @package    mod_tlive 
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once('../../../config.php');
require_once('../locallib.php');

$id  = required_param('id',  PARAM_INT);
$context = context_module::instance($id);

/* check tlive view logs capability */
if (!has_capability('mod/tlive:managelogs',  $context)) {
    print_error('notallowed', 'tlive');
}

$exp  = required_param('exp',  PARAM_RAW);
$roomsessionid  = optional_param('rsid', 0,  PARAM_INT);
$pollsessionid = optional_param('psid', 0, PARAM_INT);
/* 0 default value if param is empty */
$lessonsessionid = optional_param('lsid', 0,  PARAM_INT);

/* export polls data in pdf */
if ($exp=='pollpdf') {
    $table = tlive_buildtablepolls($pollsessionid);
    tlive_exportpdf($table);
}
/* export access data in pdf */
if ($exp =='accesspdf') {
    if ($lessonsessionid != 0) {
        $table = tlive_buildtableaccess($roomsessionid, $lessonsessionid);
    } else {
        $table = tlive_buildtableaccess($roomsessionid);
    }
    tlive_exportpdf($table);
}

/* export poll data in Excel */
if ($exp =='pollxls') {
    $table = tlive_buildtablepolls($pollsessionid);
    tlive_exportxls($table);
}

/* export access data in Excel */
if ($exp =='accessxls') {

    if ($lessonsessionid != 0) {
        $table = tlive_buildtableaccess($roomsessionid, $lessonsessionid);
    } else {
        $table = tlive_buildtableaccess($roomsessionid);
    }
    tlive_exportxls($table);
}






