<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Get json data of user sessions and polls
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

require_once(dirname(__FILE__) . '/../../../config.php');
require_once("$CFG->dirroot/mod/tlive/locallib.php");

$json = array();

$opt = optional_param('opt', '', PARAM_TEXT);
$psid = optional_param('psid', 0, PARAM_INT);
$rsid = optional_param('rsid', 0, PARAM_INT);
$lsid = optional_param('lsid', 0, PARAM_INT);

/* return a json with the number of poll answers */
if ($opt == 'answers' && $psid!=0) {
    if ($answers = $DB->get_records_sql("SELECT a.answerid, a.answer, COUNT(*)as votes FROM {tlive_users_poll_answers} as pa
     INNER JOIN {tlive_polls_answers} as a ON pa.answerid=a.answerid  WHERE pollsessionid=$psid GROUP BY pa.answerid")) {
        foreach ($answers as $a) {
            $aux = array($a->answer, (int)$a->votes);
            $json[] = $aux;
        }

    }
}

/* return a json with the user session data */
if ($opt == 'access' && $rsid!=0) {
    $roomseesionid = $rsid;
    /* query in case of lesson sessions */
    if ($lsid!=0) {
        $lessonsessionid = $lsid;
        $query = "(SELECT CONCAT(sessionid, 'add'), startdate as access, 'add'
                   FROM {tlive_lesson_user_sessions} WHERE lessonsessionid='$lessonsessionid')
                   UNION ALL
                   (SELECT CONCAT(sessionid, 'del'), enddate as access, 'del' FROM {tlive_lesson_user_sessions}
                     WHERE lessonsessionid='$lessonsessionid') ORDER BY access ASC";
    } else {
        /* othwerwise print room access data */
        $query = "(SELECT CONCAT(usersessionid, 'add'), iduser, startdate as access, 'add'
        FROM {tlive_user_sessions} WHERE roomsessionid='$roomseesionid')
        UNION ALL
        (SELECT CONCAT(usersessionid, 'del'), iduser, enddate as access, 'del'
        FROM {tlive_user_sessions}
        WHERE roomsessionid='$roomseesionid') ORDER BY access ASC";
    }

    if ($sessions = $DB->get_records_sql($query) ) {
    	
    	
    	$dtaux = new DateTime("now" , new DateTimeZone(get_user_timezone()) );	
	    $timezoneoffset = $dtaux->getOffset();
	    
	    //echo $timezoneoffset;
    	
    	
        /* attendace count number */
        $count=0;
        /* $time_offset = date('Z');
        auxiliary var to save prec time of enter/exit room */
        $precaccess = 0;
        foreach ($sessions as $s) {
            $preccount = $count;
            if ($s->add=='add') {
                $count++;
            } else {
                $count--;
            }

            //$timezoneoffset = get_user_timezone_offset();
            
            
		        

            /* if time zone is default (local time server) time offset is 0*/
            //if ($timezoneoffset == 99) {
            //    $timezoneoffset = date('Z')/3600;
            //}

            //$timezoneoffset = $timezoneoffset*3600;
            /* compute save day light offset */
            $dst = dst_offset_on( (int)$s->access);
            $access = (int)$s->access + $timezoneoffset + $dst;

            /* control condition that avoid to save two adjacent items having same time instants */
            if ($access!=$precaccess && $precaccess!=0 ) {
                /* first, compute all events having same time instants, then add only one with sum of counts */
                $aux = array($precaccess*1000, (int)$preccount);
                $json[] = $aux;
                /* add actual item
                notice: timestamp converted in milliseconds */
                $aux = array($access*1000, (int)$count);
                $json[] = $aux;
            }
            $precaccess = $access;
        }
    }
}



if ($opt == 'channelusers') { 
	
	$xmlanswer = tlive_channeldatarequest();
	$xmlanswer = simplexml_load_string($xmlanswer);	
	
	$errcode = 1;
	$maxusers = "";
	
	if (isset($xmlanswer->errorcode) && (int)$xmlanswer->errorcode == 0) {		
		
		//update setting
		if (isset($xmlanswer->users) ) {			
			$maxusers = (string)$xmlanswer->users;
			$errcode = 0;
			set_config("tlive_maxusers", (string)$maxusers);
			
		}
		
	}
	
	$json = array('errcode' => $errcode, 'maxusers' => $maxusers);
}

echo json_encode($json);