<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Page that print user sessions
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
defined('MOODLE_INTERNAL') OR die('not allowed');

/* $id, $rsid, $lsid, $psid, $pid, $opt declared in view.php */
if (!empty($opt) && $opt == 'access') {

    $OUTPUT->box_start();
    $strfdate = get_string('displaydateformat',  'tlive');
    $strftime = get_string('displaytimeformat',  'tlive');

    /* Print title */
    if ($rsid != 0 && $lsid != 0) {

        $lessonsessionrecord = $DB->get_record('tlive_lesson_sessions', array('lessonsessionid' => $lsid));
        echo "<h3>".get_string('access_list', 'tlive')." - ".
        get_string("room_session",  "tlive").userdate($lessonsessionrecord->startdate, $strfdate)." ".get_string("from", "tlive").
        userdate($lessonsessionrecord->startdate, $strftime)." "
        .get_string("to", "tlive").userdate($lessonsessionrecord->enddate, $strftime)."</h3>";

    } else if ($rsid !=0) {

        $roomsessionrecord = $DB->get_record('tlive_rooms_sessions', array('roomsessionid' => $rsid));
        echo "<h3>".get_string('access_list', 'tlive')." - ".
        get_string("room_session",  "tlive").userdate($roomsessionrecord->startdate, $strfdate)." ".get_string("from", "tlive").
        userdate($roomsessionrecord->startdate, $strftime)." ".
        get_string("to", "tlive").userdate($roomsessionrecord->enddate, $strftime)."</h3>";

    }

    /* Sessions list */
    if ($rsid != 0) {

        /* Include JQuery libraries to print chart */
        $PAGE->requires->data_for_js('dirroot', $CFG->wwwroot);
        $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/charts/jquery-1.9.1.min.js'));
        $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/charts/highstock.js' ));
        $PAGE->requires->js( new moodle_url( $CFG->wwwroot . '/mod/tlive/javascript/charts/users-accesses-chart.js' ));

        /* User language choice for chart */
        $lang = $USER->lang;
        $PAGE->requires->js( new moodle_url ($CFG->wwwroot . '/mod/tlive/javascript/charts/lang/'.$lang.'.js') );

        /* Print access chart */
        echo "<div id=\"container\" style=\"min-width: 400px;height: 400px;margin: 0 auto\"></div>";

        /* Flag to call room session or lession session print */
        if ($lsid != 0) {

            $tableuserssessions = tlive_buildtableaccess($rsid, $lsid);

        } else {

            $tableuserssessions = tlive_buildtableaccess($rsid);

        }
        $qrstr = $_SERVER["QUERY_STRING"];

        if ($tableuserssessions->data) {
            echo "<div style=\"text-align:right;margin-bottom:1%;\">".get_string('export', 'tlive')."
           <a target=\"_blank\" href=\"$CFG->wwwroot/mod/tlive/logs/export-table.php?$qrstr&exp=accesspdf\">
           <img src=\"$CFG->wwwroot/mod/tlive/javascript/charts/pdf.png\"></a>&nbsp;
           <a target=\"_blank\" href=\"$CFG->wwwroot/mod/tlive/logs/export-table.php?$qrstr&exp=accessxls\">
           <img src=\"$CFG->wwwroot/mod/tlive/javascript/charts/xls.png\"></a>
           </div>";

            echo html_writer::table($tableuserssessions);
        }
    }

    $OUTPUT->box_end();
}