<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Print page error if room creation is failed
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

defined('MOODLE_INTERNAL') OR die('not allowed');

print_container_start(true, 'box generalbox boxaligncenter boxwidthnormal');

if (tlive_useris_conferencemanagercandidate($cm)) {
    /* check capability
     * $xml_answer is defined in view.php that includes this file */

    $a = tlive_readxmlanswer($xmlanswer, 'errormessage');
    print_string('roomcreationfailed', 'tlive', $a);

} else {

    /* if user has not capability */
    print_string('uselessinstance', 'tlive');
}

print_container_end();
