<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Create tab structure for view page
 *
 * @package    mod_tlive
 * @copyright  2013  Teleskill Italia S.r.l
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/

defined('MOODLE_INTERNAL') OR die('not allowed');

$tabs = array();
$row  = array();
$inactive = array();
$activated = array();

$baseurl = $CFG->wwwroot.'/mod/tlive/view.php?id='.$id.'&amp;tab=';

if (tlive_usercan_managelogs($cm)) {
    /*  the main two tabs
     * ==> first tab */
    $row[] = new tabobject(TLIVE_TAB1, $baseurl.TLIVE_TAB1, get_string('firsttabname', 'tlive'));

    /* ==> second tab */
    $row[] = new tabobject(TLIVE_TAB2, $baseurl.TLIVE_TAB2, get_string('secondtabname', 'tlive'));
}


/* ==> tab definition */
$tabs[] = $row; /* tabs is an array of arrays */

$inactive[] = $currenttab;
$activated[] = $currenttab;

switch ($currenttab) {
    case TLIVE_NOTAB:
    case TLIVE_TAB1:
        break;
    case TLIVE_TAB2:
        $inactive[] = $currentpagename;
        $activated[] = $currentpagename;

        $baseurl = $CFG->wwwroot.'/mod/tlive/view.php?id='.$cm->id.'&amp;tab='.TLIVE_TAB2.'&amp;pag=';

        $row  = array();
        $strlabel = get_string('tab2page1', 'tlive');
        $row[] = new tabobject(TLIVE_TAB2_PAGE1NAME, $baseurl.TLIVE_TAB2_PAGE1, $strlabel);

        $strlabel = get_string('tab2page2', 'tlive');
        if (phpversion() < '5') {
            $strlabel .= get_string('star', 'tlive');
        }
        $row[] = new tabobject(TLIVE_TAB2_PAGE2NAME, $baseurl.TLIVE_TAB2_PAGE2, $strlabel);

        $tabs[] = $row;
        break;
    default:
        echo 'I am at the row '.__LINE__.' of the file '.__FILE__.'<br />';
        echo 'I have $currenttab = '.$currenttab.'<br />';
        echo 'But the right "case" is missing<br />';
}

print_tabs($tabs, $currenttab, $inactive, $activated);
